/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.database.entity;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.romstation.application.N;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.Publisher;
import org.romstation.application.database.entity.RemoteEntity;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.Series;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.Tag;

@Entity
@Table(name="GAME")
@Access(value=AccessType.PROPERTY)
@NamedQueries(value={@NamedQuery(name="Game.countAll", query="select count(game) from Game game"), @NamedQuery(name="Game.findByRID", query="select game from Game game where game.rid = :rid")})
public class Game
extends RemoteEntity {
    public static final String a = "Game.countAll";
    public static final String b = "Game.findByRID";
    private String c;
    private System d;
    private List<Language> e = new LinkedList<Language>();
    private List<Genre> f = new LinkedList<Genre>();
    private Integer g;
    private Developer h;
    private Publisher i;
    private List<Series> j = new LinkedList<Series>();
    private Integer k;
    private I18n l;
    private Image m;
    private boolean n;
    private List<Tag> o = new LinkedList<Tag>();
    private List<Link> p = new LinkedList<Link>();
    private String q;
    private List<Script> r = new LinkedList<Script>();
    private List<GameFile> s = new LinkedList<GameFile>();
    private Map<String, String> t = new HashMap<String, String>();
    private Long u;
    private Long v;

    @Override
    @Id
    @SequenceGenerator(name="GAME_GENERATOR", sequenceName="GAME_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GAME_GENERATOR")
    public Integer getId() {
        return super.getId();
    }

    public String getTitle() {
        return this.c;
    }

    public void setTitle(String title) {
        this.c = title;
    }

    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public System getSystem() {
        return this.d;
    }

    public void setSystem(System system) {
        this.d = system;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="LANGUAGE_ID")})
    public List<Language> getLanguages() {
        return this.e;
    }

    public void setLanguages(List<Language> languages) {
        this.e = languages;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="GENRE_ID")})
    public List<Genre> getGenres() {
        return this.f;
    }

    public void setGenres(List<Genre> genres) {
        this.f = genres;
    }

    public Integer getPlayers() {
        return this.g;
    }

    public void setPlayers(Integer players) {
        this.g = players;
    }

    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public Developer getDeveloper() {
        return this.h;
    }

    public void setDeveloper(Developer developer) {
        this.h = developer;
    }

    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public Publisher getPublisher() {
        return this.i;
    }

    public void setPublisher(Publisher publisher) {
        this.i = publisher;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="SERIES_ID")})
    public List<Series> getSeries() {
        return this.j;
    }

    public void setSeries(List<Series> series) {
        this.j = series;
    }

    @Column(name="\"YEAR\"")
    public Integer getYear() {
        return this.k;
    }

    public void setYear(Integer year) {
        this.k = year;
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="DESCRIPTION_I18N_ID")
    public I18n getDescription() {
        return this.l;
    }

    public void setDescription(I18n description) {
        this.l = description;
    }

    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="GRAPHIC_IMAGE_ID")
    public Image getGraphic() {
        return this.m;
    }

    public void setGraphic(Image cover) {
        this.m = cover;
    }

    public boolean isManaged() {
        return this.n;
    }

    public void setManaged(boolean managed) {
        this.n = managed;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="TAG_ID")})
    public List<Tag> getTags() {
        return this.o;
    }

    public void setTags(List<Tag> tags) {
        this.o = tags;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(inverseJoinColumns={@JoinColumn(name="LINK_ID")})
    public List<Link> getLinks() {
        return this.p;
    }

    public void setLinks(List<Link> links) {
        this.p = links;
    }

    public String getDirectory() {
        return this.q;
    }

    public void setDirectory(String directory) {
        this.q = directory;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(inverseJoinColumns={@JoinColumn(name="SCRIPT_ID")})
    public List<Script> getScripts() {
        return this.r;
    }

    public void setScripts(List<Script> scripts) {
        this.r = scripts;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="GAME_ID")
    public List<GameFile> getFiles() {
        return this.s;
    }

    public void setFiles(List<GameFile> files) {
        this.s = files;
    }

    @ElementCollection
    @MapKeyColumn(name="\"KEY\"")
    @Column(name="VALUE", length=32672)
    @CollectionTable(name="GAME_META", joinColumns={@JoinColumn(name="GAME_ID")})
    public Map<String, String> getMetas() {
        return this.t;
    }

    public void setMetas(Map<String, String> meta) {
        this.t = meta;
    }

    @Column(name="LAST_USE")
    public Long getLastUse() {
        return this.u;
    }

    public void setLastUse(Long lastUse) {
        this.u = lastUse;
    }

    public Long getPlayed() {
        return this.v;
    }

    public void setPlayed(Long played) {
        this.v = played;
    }

    @PrePersist
    private void prePersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_persist")) continue;
                rubyObject.callMethod("on_pre_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_pre_persist != null) {
            N.a().database.game.on_pre_persist.accept(this);
        }
    }

    @PostPersist
    private void postPersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_persist")) continue;
                rubyObject.callMethod("on_post_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_post_persist != null) {
            N.a().database.game.on_post_persist.accept(this);
        }
    }

    @PreUpdate
    private void preUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_update")) continue;
                rubyObject.callMethod("on_pre_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_pre_update != null) {
            N.a().database.game.on_pre_update.accept(this);
        }
    }

    @PostUpdate
    private void postUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_update")) continue;
                rubyObject.callMethod("on_post_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_post_update != null) {
            N.a().database.game.on_post_update.accept(this);
        }
    }

    @PreRemove
    private void preRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_remove")) continue;
                rubyObject.callMethod("on_pre_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_pre_remove != null) {
            N.a().database.game.on_pre_remove.accept(this);
        }
    }

    @PostRemove
    private void postRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_remove")) continue;
                rubyObject.callMethod("on_post_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game.on_post_remove != null) {
            N.a().database.game.on_post_remove.accept(this);
        }
    }

    public String toString() {
        return "[" + this.getId() + "] " + this.c;
    }
}

