/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.database.entity;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaUtil;
import org.romstation.application.N;
import org.romstation.application.RomStation;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.a;

@Entity
@Table(name="GAME_PROFILE")
@Access(value=AccessType.PROPERTY)
public class GameProfile
extends a {
    private String a;
    private String b;
    private GameFile c;
    private EmulatorProfile d;
    private String e;
    private List<Script> f = new LinkedList<Script>();
    private Map<String, String> g = new HashMap<String, String>();

    public GameProfile() {
    }

    public GameProfile(GameProfile entity) {
        this.a = entity.getName();
        this.b = entity.getPath();
        this.c = entity.getGameFile();
        this.d = entity.getEmulatorProfile();
        this.e = entity.getParameters();
        this.g.putAll(entity.getMetas());
        this.f.addAll(entity.getScripts());
    }

    @Override
    @Id
    @SequenceGenerator(name="GAME_PROFILE_GENERATOR", sequenceName="GAME_PROFILE_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GAME_PROFILE_GENERATOR")
    public Integer getId() {
        return super.getId();
    }

    public String getName() {
        return this.a;
    }

    public void setName(String name) {
        this.a = name;
    }

    public String getPath() {
        return this.b;
    }

    public void setPath(String path) {
        this.b = path;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="GAME_FILE_ID")
    public GameFile getGameFile() {
        return this.c;
    }

    public void setGameFile(GameFile gameFile) {
        this.c = gameFile;
    }

    @OneToOne
    @JoinColumn(name="EMULATOR_PROFILE_ID")
    public EmulatorProfile getEmulatorProfile() {
        return this.d;
    }

    public void setEmulatorProfile(EmulatorProfile emulatorProfile) {
        this.d = emulatorProfile;
    }

    public String getParameters() {
        return this.e;
    }

    public void setParameters(String parameters) {
        this.e = parameters;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(joinColumns={@JoinColumn(name="GAME_PROFILE_ID")}, inverseJoinColumns={@JoinColumn(name="SCRIPT_ID")})
    public List<Script> getScripts() {
        return this.f;
    }

    public void setScripts(List<Script> scripts) {
        this.f = scripts;
    }

    @ElementCollection
    @MapKeyColumn(name="\"KEY\"")
    @Column(name="VALUE", length=32672)
    @CollectionTable(name="GAME_PROFILE_META", joinColumns={@JoinColumn(name="GAME_PROFILE_ID")})
    public Map<String, String> getMetas() {
        return this.g;
    }

    public void setMetas(Map<String, String> meta) {
        this.g = meta;
    }

    @PrePersist
    private void prePersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_persist")) continue;
                rubyObject.callMethod("on_pre_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_pre_persist != null) {
            N.a().database.game_profile.on_pre_persist.accept(this);
        }
    }

    @PostPersist
    private void postPersist() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_persist")) continue;
                rubyObject.callMethod("on_post_persist", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_post_persist != null) {
            N.a().database.game_profile.on_post_persist.accept(this);
        }
    }

    @PreUpdate
    private void preUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_update")) continue;
                rubyObject.callMethod("on_pre_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_pre_update != null) {
            N.a().database.game_profile.on_pre_update.accept(this);
        }
    }

    @PostUpdate
    private void postUpdate() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_update")) continue;
                rubyObject.callMethod("on_post_update", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_post_update != null) {
            N.a().database.game_profile.on_post_update.accept(this);
        }
    }

    @PreRemove
    private void preRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_pre_remove")) continue;
                rubyObject.callMethod("on_pre_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_pre_remove != null) {
            N.a().database.game_profile.on_pre_remove.accept(this);
        }
    }

    @PostRemove
    private void postRemove() {
        for (Script script : this.getScripts()) {
            try {
                RubyObject rubyObject = N.a(script);
                if (!rubyObject.respondsTo("on_post_remove")) continue;
                rubyObject.callMethod("on_post_remove", JavaUtil.convertJavaToRuby((Ruby)rubyObject.getRuntime(), (Object)this));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (N.a().database.game_profile.on_post_remove != null) {
            N.a().database.game_profile.on_post_remove.accept(this);
        }
    }

    public String toString() {
        return "[" + this.getId() + "] " + this.a;
    }
}

