/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.concurrent.Task;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.romstation.application.RomStation;
import org.romstation.application.W;
import org.romstation.application.ag;
import org.romstation.application.ak;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.System;
import org.romstation.application.io.ChecksumException;
import org.romstation.application.network.g;
import org.romstation.application.task.B;
import org.romstation.application.task.a;
import org.romstation.application.task.b;
import org.romstation.application.task.h;
import org.romstation.application.task.v;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class i
extends Task<EmulatorFile> {
    private final int a = 1000;
    private ak b;
    private v c;
    private b d;
    private B e;
    private Path f;
    private EntityManager g;
    private final List<System> h = new LinkedList<System>();
    private final h i;
    private XPath j;

    public i(h context) {
        this.i = context;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.j = xPathFactory.newXPath();
    }

    public h a() {
        return this.i;
    }

    public ak b() {
        return this.b;
    }

    protected void scheduled() {
        this.updateTitle(RomStation.d().getString("emulator.download.task.title"));
    }

    protected void cancelled() {
        if (this.c != null && this.c.isRunning()) {
            this.c.cancel(false);
        }
        if (this.d != null && this.d.isRunning()) {
            this.d.cancel(false);
        }
        if (this.e != null && this.e.isRunning()) {
            this.e.cancel(false);
        }
    }

    protected EmulatorFile c() throws Exception {
        try {
            this.d();
            this.e();
            EmulatorFile emulatorFile = this.f();
            this.updateValue(emulatorFile);
            return emulatorFile;
        }
        catch (InterruptedException | CancellationException exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() throws Exception {
        this.updateMessage(RomStation.d().getString("emulator.download.task.message.downloading"));
        this.f = Paths.get("cache/downloads/emulators", this.j.evaluate("/EmulatorFile/@id", this.i.d()));
        Files.createDirectories(this.f.getParent(), new FileAttribute[0]);
        JsonParser parser = new JsonParser();
        String protocol = this.i.a().get("protocol").getAsString();
        JsonObject credential = parser.parse(W.b(this.i.a().get(protocol).getAsString())).getAsJsonObject();
        this.c = new v(credential.get("url").getAsString(), this.f);
        this.c.a(true);
        this.c.b(true);
        this.c.a(new g().a("auth", ag.a().f()).a("file_path", this.i.a().getAsJsonObject("file").get("path").getAsString()).toString());
        this.c.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.c.getWorkDone(), this.c.getTotalWork()));
        ScheduledExecutorService progressService = Executors.newSingleThreadScheduledExecutor();
        this.c.workDoneProperty().addListener((observableValue, previousValue, currentValue) -> {
            if (this.b == null) {
                this.b = new ak(currentValue.longValue(), this.c.getTotalWork());
                if (!progressService.isShutdown()) {
                    progressService.scheduleWithFixedDelay(() -> this.b.h(), 1000L, 1000L, TimeUnit.MILLISECONDS);
                }
            } else {
                this.b.a(currentValue.longValue() - previousValue.longValue());
            }
        });
        this.c.run();
        try {
            this.c.get();
        }
        finally {
            progressService.shutdown();
        }
    }

    private void e() throws Exception {
        this.d = new a(this.f);
        this.d.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.d.getWorkDone(), this.d.getTotalWork()));
        this.updateMessage(RomStation.d().getString("emulator.download.task.message.verifying"));
        this.d.run();
        String localChecksum = (String)this.d.get();
        String serverChecksum = this.i.a().getAsJsonObject("file").get("crc32").getAsString();
        if (!serverChecksum.equals(localChecksum)) {
            Files.delete(this.f);
            throw new ChecksumException("Checksum invalid");
        }
    }

    private void a(Path source, Path target) throws Exception {
        this.e = new B(source, target);
        this.e.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.e.getWorkDone(), this.e.getTotalWork()));
        this.updateMessage(RomStation.d().getString("emulator.download.task.message.unpacking"));
        this.e.run();
        this.e.get();
        Files.delete(source);
    }

    private System a(JsonObject jsonObject) throws Exception {
        Path output = Paths.get("images/systems", new String[0]).resolve(Paths.get(jsonObject.get("image").getAsString(), new String[0]).getFileName());
        URL url = new URL(org.romstation.application.network.b.b() + jsonObject.get("image").getAsString());
        try (InputStream stream = url.openStream();){
            Files.copy(stream, output, StandardCopyOption.REPLACE_EXISTING);
        }
        System system = new System();
        system.setRid(jsonObject.get("id").getAsInt());
        system.setName(jsonObject.get("name").getAsString());
        system.setGraphic(new Image(output));
        return system;
    }

    private void a(JsonArray jsonArray) throws Exception {
        List entities = this.g.createNamedQuery("System.findAll", System.class).getResultList();
        for (JsonElement element : jsonArray) {
            JsonObject jsonObject = element.getAsJsonObject();
            Optional<System> optional = entities.stream().filter(system -> Objects.equals(system.getRid(), jsonObject.get("id").getAsInt())).findAny();
            this.h.add(optional.isPresent() ? optional.get() : this.a(jsonObject));
        }
    }

    private List<System> a(Element element) {
        LinkedList<System> result = new LinkedList<System>();
        NodeList nodeList = element.getElementsByTagName("System");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element systemElement = (Element)nodeList.item(i2);
            Optional<System> optional = this.h.stream().filter(system -> Objects.equals(system.getRid(), Integer.parseInt(systemElement.getAttribute("id")))).findAny();
            optional.ifPresent(result::add);
        }
        return result;
    }

    private List<Script> a(Path root, Element element) {
        LinkedList<Script> scripts = new LinkedList<Script>();
        NodeList nodeList = element.getElementsByTagName("Script");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            scripts.add(this.b(root, (Element)nodeList.item(i2)));
        }
        return scripts;
    }

    private Script b(Path root, Element element) {
        Script script = new Script();
        script.setPath(root.resolve(element.getAttribute("path")).toString());
        return script;
    }

    private Map<String, String> b(Element element) {
        HashMap<String, String> metas = new HashMap<String, String>();
        NodeList nodeList = element.getElementsByTagName("Meta");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element meta = (Element)nodeList.item(i2);
            metas.put(meta.getAttribute("key"), meta.hasAttribute("value") ? meta.getAttribute("value") : null);
        }
        return metas;
    }

    private List<Link> c(Element element) {
        LinkedList<Link> links = new LinkedList<Link>();
        NodeList nodeList = element.getElementsByTagName("Link");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            links.add(this.d((Element)nodeList.item(i2)));
        }
        return links;
    }

    private Link d(Element element) {
        Link link = new Link();
        link.setName(element.getAttribute("name"));
        link.setExternal(Boolean.parseBoolean(element.getAttribute("external")));
        if (link.isExternal()) {
            link.setLocation(element.getAttribute("location"));
        } else {
            link.setLocation(org.romstation.application.network.b.b() + element.getAttribute("location"));
        }
        return link;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Image a(Path output, String imagePath, String rename) {
        Path target = output.resolve(rename + imagePath.substring(imagePath.lastIndexOf(46)));
        try {
            URL url = new URL(org.romstation.application.network.b.b() + imagePath);
            try (InputStream stream = url.openStream();){
                Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
                Image image = new Image(target);
                return image;
            }
            catch (IOException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                return null;
            }
        }
        catch (MalformedURLException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    private Emulator e(Element element) throws IOException {
        Path dir = Paths.get(RomStation.c().getProperty("path.emulators"), "downloads", element.getAttribute("directory"));
        Emulator emulator = new Emulator();
        emulator.setRid(Integer.valueOf(element.getAttribute("id")));
        emulator.setName(element.getAttribute("name"));
        emulator.setDirectory(dir.toString());
        Path graphicOutputPath = dir.resolve("images");
        Files.createDirectories(graphicOutputPath, new FileAttribute[0]);
        emulator.setGraphic(this.a(graphicOutputPath, element.getAttribute("image"), emulator.getName()));
        NodeList children = element.getChildNodes();
        block8: for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node node = children.item(i2);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "Links": {
                    emulator.setLinks(this.c((Element)node));
                    continue block8;
                }
                case "Metas": {
                    emulator.setMetas(this.b((Element)node));
                }
            }
        }
        emulator.setManaged(true);
        return emulator;
    }

    private EmulatorFile a(Emulator emulator, Element element) {
        EmulatorFile emulatorFile = new EmulatorFile();
        emulatorFile.setRid(Integer.valueOf(element.getAttribute("id")));
        emulatorFile.setName(element.getAttribute("name"));
        Path fileOutputPath = Paths.get(emulator.getDirectory(), "files", element.getAttribute("directory"));
        emulatorFile.setDirectory(fileOutputPath.toString());
        emulatorFile.setEmulator(emulator);
        NodeList children = element.getChildNodes();
        block10: for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node node = children.item(i2);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "EmulatorProfiles": {
                    emulatorFile.setProfiles(this.a(emulatorFile, (Element)node));
                    continue block10;
                }
                case "Scripts": {
                    emulatorFile.setScripts(this.a(fileOutputPath, (Element)node));
                    continue block10;
                }
                case "Metas": {
                    emulatorFile.setMetas(this.b((Element)node));
                }
            }
        }
        emulatorFile.setManaged(true);
        return emulatorFile;
    }

    private List<EmulatorProfile> a(EmulatorFile emulatorFile, Element element) {
        LinkedList<EmulatorProfile> profiles = new LinkedList<EmulatorProfile>();
        NodeList nodeList = element.getElementsByTagName("EmulatorProfile");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            profiles.add(this.b(emulatorFile, (Element)nodeList.item(i2)));
        }
        return profiles;
    }

    private EmulatorProfile b(EmulatorFile emulatorFile, Element element) {
        EmulatorProfile emulatorProfile = new EmulatorProfile();
        emulatorProfile.setName(element.getAttribute("name"));
        if (element.hasAttribute("parameters")) {
            emulatorProfile.setParameters(element.getAttribute("parameters"));
        }
        emulatorProfile.setPath(Paths.get(emulatorFile.getDirectory(), element.getAttribute("path")).toString());
        emulatorProfile.setWorkingDirectory(element.getAttribute("working_directory"));
        emulatorProfile.setEmulatorFile(emulatorFile);
        NodeList children = element.getChildNodes();
        block10: for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node node = children.item(i2);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "Systems": {
                    emulatorProfile.setSystems(this.a((Element)node));
                    continue block10;
                }
                case "Scripts": {
                    emulatorProfile.setScripts(this.a(Paths.get(emulatorFile.getDirectory(), new String[0]), (Element)node));
                    continue block10;
                }
                case "Metas": {
                    emulatorProfile.setMetas(this.b((Element)node));
                }
            }
        }
        return emulatorProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmulatorFile f() throws Exception {
        try {
            Emulator emulator;
            this.g = org.romstation.application.b.c();
            this.a(this.i.b());
            try {
                emulator = (Emulator)this.g.createNamedQuery("Emulator.findByRid", Emulator.class).setParameter("rid", (Object)((Number)this.j.evaluate("/Emulator/@id", this.i.c(), XPathConstants.NUMBER)).intValue()).getSingleResult();
            }
            catch (NoResultException e2) {
                emulator = this.e(this.i.c().getDocumentElement());
            }
            EmulatorFile emulatorFile = this.a(emulator, this.i.d().getDocumentElement());
            emulator.getFiles().add(emulatorFile);
            Path emulatorFileDirectory = Paths.get(emulatorFile.getDirectory(), new String[0]);
            if (Files.exists(emulatorFileDirectory, new LinkOption[0])) {
                org.romstation.application.io.a.a(emulatorFileDirectory);
            }
            this.a(this.f, emulatorFileDirectory);
            this.g.getTransaction().begin();
            this.g.persist((Object)emulator);
            this.g.getTransaction().commit();
            EmulatorFile emulatorFile2 = emulatorFile;
            return emulatorFile2;
        }
        finally {
            if (this.g != null) {
                this.g.close();
            }
        }
    }

    protected /* synthetic */ Object call() throws Exception {
        return this.c();
    }
}

