/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.concurrent.Task;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.romstation.application.E;
import org.romstation.application.RomStation;
import org.romstation.application.W;
import org.romstation.application.ag;
import org.romstation.application.ak;
import org.romstation.application.b;
import org.romstation.application.cU;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.GameProfile;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Image;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Link;
import org.romstation.application.database.entity.Locale;
import org.romstation.application.database.entity.Publisher;
import org.romstation.application.database.entity.Script;
import org.romstation.application.database.entity.Series;
import org.romstation.application.database.entity.Translation;
import org.romstation.application.io.ChecksumException;
import org.romstation.application.network.InvalidServerResponseException;
import org.romstation.application.network.NetworkOfflineException;
import org.romstation.application.network.ServerResponseException;
import org.romstation.application.network.d;
import org.romstation.application.network.f;
import org.romstation.application.network.g;
import org.romstation.application.task.B;
import org.romstation.application.task.a;
import org.romstation.application.task.o;
import org.romstation.application.task.v;

public class p
extends Task<GameFile> {
    private final int a = 60000;
    private final int b = 1000;
    private final o c;
    private final ScheduledExecutorService d = Executors.newSingleThreadScheduledExecutor();
    private final ReadOnlyStringWrapper e = new ReadOnlyStringWrapper();
    private final ReadOnlyBooleanWrapper f = new ReadOnlyBooleanWrapper();
    private ak g;
    private v h;
    private a i;
    private B j;
    private Path k;
    private EntityManager l;

    public p(o context) {
        this.c = context;
    }

    public o a() {
        return this.c;
    }

    public ReadOnlyStringWrapper b() {
        return this.e;
    }

    public String c() {
        return this.e.get();
    }

    public ReadOnlyBooleanProperty d() {
        return this.f.getReadOnlyProperty();
    }

    public boolean e() {
        return this.f.get();
    }

    public ak f() {
        return this.g;
    }

    public void run() {
        cU.a().add((Object)this);
        super.run();
    }

    protected void scheduled() {
        this.updateTitle(RomStation.d().getString("game.download.task.title"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GameFile g() throws Exception {
        GameFile gameFile = null;
        this.h();
        if (this.e()) {
            long timestamp = System.currentTimeMillis();
            while (this.e() && !this.isCancelled()) {
                if (System.currentTimeMillis() - timestamp >= 60000L) {
                    this.i();
                    timestamp = System.currentTimeMillis();
                    continue;
                }
                Thread.sleep(1L);
            }
        }
        if (!this.isCancelled()) {
            this.d.scheduleWithFixedDelay(this::j, 60000L, 60000L, TimeUnit.MILLISECONDS);
            try {
                this.m();
                this.n();
                gameFile = this.p();
                this.k();
                this.updateMessage(RomStation.d().getString("game.download.task.message.done"));
            }
            catch (InterruptedException | CancellationException exception) {
            }
            finally {
                this.d.shutdown();
            }
        }
        this.l();
        return gameFile;
    }

    protected void cancelled() {
        if (this.h != null && this.h.isRunning()) {
            this.h.cancel(false);
        }
        if (this.i != null && this.i.isRunning()) {
            this.i.cancel(false);
        }
        if (this.j != null && this.j.isRunning()) {
            this.j.cancel(false);
        }
    }

    protected void done() {
        cU.a().remove((Object)this);
    }

    private void h() throws MalformedURLException, NetworkOfflineException, ServerResponseException, InvalidServerResponseException {
        f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/download/start.php");
        builder.a().a("v", 229).a("os", E.c().a()).a("gfid", this.c.c().get("file_id").getAsInt());
        g post = new g().a("auth", ag.a().f());
        org.romstation.application.network.a request = new org.romstation.application.network.a(builder.b());
        d response = request.a(post);
        if (response.b().get("queue").getAsJsonObject().get("wait").getAsInt() == 1) {
            this.f.set(true);
            this.a(response.b().get("queue").getAsJsonObject().get("position").getAsInt());
        } else {
            this.c.a(response.b().get("download").getAsJsonObject());
        }
        if (!response.b().get("ad").isJsonNull()) {
            this.e.set(org.romstation.application.network.b.b() + response.b().get("ad").getAsString());
        }
    }

    private void i() throws MalformedURLException, NetworkOfflineException, ServerResponseException, InvalidServerResponseException {
        f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/download/update.php");
        builder.a().a("v", 229).a("os", E.c().a()).a("gfid", this.c.c().get("file_id").getAsInt());
        g post = new g().a("auth", ag.a().f());
        org.romstation.application.network.a request = new org.romstation.application.network.a(builder.b());
        d response = request.a(post);
        if (response.b().get("queue").getAsJsonObject().get("wait").getAsInt() == 1) {
            this.a(response.b().get("queue").getAsJsonObject().get("position").getAsInt());
        } else {
            this.f.set(false);
            this.c.a(response.b().get("download").getAsJsonObject());
        }
    }

    private void j() {
        try {
            f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/download/update.php");
            builder.a().a("v", 229).a("os", E.c().a()).a("gfid", this.c.c().get("file_id").getAsInt());
            if (this.g != null && !this.h.isDone()) {
                builder.a().a("running", 1).a("speed", (long)this.g.j()).a("progress", this.g.f());
            }
            g post = new g().a("auth", ag.a().f());
            org.romstation.application.network.a request = new org.romstation.application.network.a(builder.b());
            request.a(post);
        }
        catch (Exception exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void k() throws MalformedURLException, NetworkOfflineException, ServerResponseException, InvalidServerResponseException {
        f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/download/set_downloaded.php");
        builder.a().a("v", 229).a("os", E.c().a()).a("gfid", this.c.c().get("file_id").getAsString());
        if (this.g != null) {
            builder.a().a("speed", (long)this.g.j());
        }
        g post = new g().a("auth", ag.a().f());
        org.romstation.application.network.a request = new org.romstation.application.network.a(builder.b());
        request.a(post);
    }

    private void l() throws MalformedURLException, NetworkOfflineException, ServerResponseException, InvalidServerResponseException {
        f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/download/end.php");
        builder.a().a("v", 229).a("os", E.c().a());
        g post = new g().a("auth", ag.a().f());
        org.romstation.application.network.a request = new org.romstation.application.network.a(builder.b());
        request.a(post);
    }

    private void a(int queuePosition) {
        this.updateMessage(String.format(RomStation.d().getString("game.download.task.message.queue"), queuePosition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m() throws Exception {
        this.updateMessage(RomStation.d().getString("game.download.task.message.downloading"));
        this.k = Paths.get("cache/downloads/games", this.c.c().get("name").getAsString());
        Files.createDirectories(this.k.getParent(), new FileAttribute[0]);
        JsonParser parser = new JsonParser();
        String protocol = this.c.a().get("protocol").getAsString();
        JsonObject credential = parser.parse(W.b(this.c.a().get(protocol).getAsString())).getAsJsonObject();
        this.h = new v(credential.get("url").getAsString(), this.k);
        this.h.a(true);
        this.h.b(true);
        this.h.a(new g().a("auth", ag.a().f()).a("token", credential.get("token").getAsString()).toString());
        this.h.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.h.getWorkDone(), this.h.getTotalWork()));
        ScheduledExecutorService progressService = Executors.newSingleThreadScheduledExecutor();
        this.h.workDoneProperty().addListener((observableValue, previousValue, currentValue) -> {
            if (this.g == null) {
                this.g = new ak(currentValue.longValue(), this.h.getTotalWork());
                if (!progressService.isShutdown()) {
                    progressService.scheduleWithFixedDelay(() -> this.g.h(), 1000L, 1000L, TimeUnit.MILLISECONDS);
                }
            } else {
                this.g.a(currentValue.longValue() - previousValue.longValue());
            }
        });
        this.h.run();
        try {
            this.h.get();
        }
        finally {
            progressService.shutdown();
        }
    }

    private void n() throws Exception {
        this.i = new a(this.k);
        this.i.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.i.getWorkDone(), this.i.getTotalWork()));
        this.updateMessage(RomStation.d().getString("game.download.task.message.verifying"));
        this.i.run();
        String localChecksum = (String)this.i.get();
        String serverChecksum = this.c.c().get("crc32").getAsString();
        if (!serverChecksum.equals(localChecksum)) {
            Files.delete(this.k);
            throw new ChecksumException("Checksum invalid");
        }
    }

    private void a(Path target) throws ExecutionException, InterruptedException, IOException {
        this.j = new B(this.k, target);
        this.j.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress(this.j.getWorkDone(), this.j.getTotalWork()));
        this.updateMessage(RomStation.d().getString("game.download.task.message.unpacking"));
        this.j.run();
        this.j.get();
        Files.delete(this.k);
    }

    private Game a(JsonObject json) throws Exception {
        Game game = new Game();
        game.setRid(json.get("id").getAsInt());
        game.setTitle(json.get("title").getAsString());
        game.setPlayers(json.get("players").getAsInt());
        game.setYear(json.get("release_date").getAsInt());
        game.setLinks(this.a(json.getAsJsonArray("links")));
        game.setSystem(this.c(json.getAsJsonObject("system")));
        game.setDescription(this.d(json.getAsJsonObject("description")));
        game.getLanguages().addAll(this.b(json.getAsJsonArray("languages")));
        game.getGenres().addAll(this.c(json.getAsJsonArray("genres")));
        game.setDeveloper(this.h(json.getAsJsonObject("developer")));
        game.setPublisher(this.j(json.getAsJsonObject("publisher")));
        game.getSeries().addAll(this.d(json.getAsJsonArray("series")));
        game.setManaged(true);
        String dirName = org.romstation.application.io.a.a(MessageFormat.format("{0} - {1,number,#}", game.getTitle(), game.getRid()));
        Path dir = Paths.get(RomStation.c().getProperty("path.games"), "downloads", dirName);
        Files.createDirectories(dir, new FileAttribute[0]);
        game.setDirectory(dir.toString());
        Path graphicOutput = dir.resolve("images/cover.png");
        Files.createDirectories(graphicOutput.getParent(), new FileAttribute[0]);
        URL graphicInput = new URL(org.romstation.application.network.b.b() + json.get("cover").getAsString());
        try (InputStream stream = graphicInput.openStream();){
            Files.copy(stream, graphicOutput, StandardCopyOption.REPLACE_EXISTING);
            game.setGraphic(new Image(graphicOutput));
        }
        if (!json.get("meta").isJsonNull()) {
            if (json.getAsJsonObject("meta").has("metas")) {
                json.getAsJsonObject("meta").getAsJsonArray("metas").forEach(jsonElement -> {
                    JsonObject object = jsonElement.getAsJsonObject();
                    game.getMetas().put(object.get("key").getAsString(), object.get("value").getAsString());
                });
            }
            if (json.getAsJsonObject("meta").has("scripts")) {
                json.getAsJsonObject("meta").getAsJsonArray("scripts").forEach(jsonElement -> game.getScripts().add(new Script(Paths.get(game.getDirectory(), jsonElement.getAsString()).toString())));
            }
        }
        return game;
    }

    private GameFile a(Game game) throws IOException, ExecutionException, InterruptedException {
        JsonObject metaJsonObject = this.c.c().getAsJsonObject("meta");
        Path directoryPath = Paths.get(game.getDirectory(), "files", this.c.c().get("file_id").getAsString());
        if (this.c.c().get("deflate").getAsBoolean()) {
            if (Files.exists(directoryPath, new LinkOption[0])) {
                org.romstation.application.io.a.a(directoryPath);
            }
            this.a(directoryPath);
        } else {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
            Files.move(this.k, directoryPath.resolve(this.c.c().get("name").getAsString()), StandardCopyOption.REPLACE_EXISTING);
        }
        GameFile gameFile = new GameFile();
        gameFile.setRid(this.c.c().get("file_id").getAsInt());
        gameFile.setName(this.c.c().get("label").getAsString());
        gameFile.setDirectory(directoryPath.toString());
        gameFile.setGame(game);
        gameFile.setManaged(true);
        if (metaJsonObject.has("metas")) {
            metaJsonObject.getAsJsonArray("metas").forEach(jsonElement -> {
                JsonObject object = jsonElement.getAsJsonObject();
                gameFile.getMetas().put(object.get("key").getAsString(), object.get("value").getAsString());
            });
        }
        if (metaJsonObject.has("scripts")) {
            metaJsonObject.getAsJsonArray("scripts").forEach(jsonElement -> gameFile.getScripts().add(new Script(Paths.get(gameFile.getDirectory(), jsonElement.getAsString()).toString())));
        }
        metaJsonObject.getAsJsonArray("profiles").forEach(jsonElement -> gameFile.getProfiles().add(this.a(gameFile, jsonElement.getAsJsonObject())));
        return gameFile;
    }

    private GameProfile a(GameFile gameFile, JsonObject profileObject) {
        GameProfile gameProfile = new GameProfile();
        gameProfile.setName(profileObject.get("name").getAsString().replace("${gameFile.name}", gameFile.getName()));
        if (profileObject.get("target").isJsonNull() || profileObject.get("target").getAsString().isEmpty()) {
            gameProfile.setPath(Paths.get(gameFile.getDirectory(), this.c.c().get("name").getAsString()).toString());
        } else {
            gameProfile.setPath(Paths.get(gameFile.getDirectory(), profileObject.get("target").getAsString()).toString());
        }
        if (profileObject.has("parameters")) {
            gameProfile.setParameters(profileObject.get("parameters").isJsonNull() ? null : profileObject.get("parameters").getAsString());
        }
        gameProfile.setGameFile(gameFile);
        if (profileObject.has("metas")) {
            profileObject.getAsJsonArray("metas").forEach(jsonElement -> {
                JsonObject object = jsonElement.getAsJsonObject();
                gameProfile.getMetas().put(object.get("key").getAsString(), object.get("value").getAsString());
            });
        }
        if (profileObject.has("scripts")) {
            profileObject.getAsJsonArray("scripts").forEach(jsonElement -> gameProfile.getScripts().add(new Script(Paths.get(gameFile.getDirectory(), jsonElement.getAsString()).toString())));
        }
        return gameProfile;
    }

    private List<Link> a(JsonArray jsonArray) {
        LinkedList<Link> links = new LinkedList<Link>();
        jsonArray.forEach(element -> {
            JsonObject jsonObject = element.getAsJsonObject();
            Link link = new Link();
            link.setName(jsonObject.get("name").getAsString());
            link.setExternal(jsonObject.get("external").getAsBoolean());
            if (link.isExternal()) {
                link.setLocation(jsonObject.get("location").getAsString());
            } else {
                link.setLocation(org.romstation.application.network.b.b() + jsonObject.get("location").getAsString());
            }
            links.add(link);
        });
        return links;
    }

    private org.romstation.application.database.entity.System b(JsonObject jsonObject) throws Exception {
        Path output = Paths.get("images/systems", new String[0]).resolve(Paths.get(jsonObject.get("image").getAsString(), new String[0]).getFileName());
        URL url = new URL(org.romstation.application.network.b.b() + jsonObject.get("image").getAsString());
        try (InputStream stream = url.openStream();){
            Files.copy(stream, output, StandardCopyOption.REPLACE_EXISTING);
        }
        org.romstation.application.database.entity.System system = new org.romstation.application.database.entity.System();
        system.setRid(jsonObject.get("id").getAsInt());
        system.setName(jsonObject.get("name").getAsString());
        system.setGraphic(new Image(output));
        return system;
    }

    private org.romstation.application.database.entity.System c(JsonObject jsonObject) throws Exception {
        try {
            return (org.romstation.application.database.entity.System)this.l.createNamedQuery("System.findByRID", org.romstation.application.database.entity.System.class).setParameter("rid", (Object)jsonObject.get("id").getAsInt()).getSingleResult();
        }
        catch (NoResultException ex) {
            return this.b(jsonObject);
        }
    }

    private Map<String, Locale> o() {
        return this.l.createNamedQuery("Locale.findAll", Locale.class).getResultList().stream().collect(Collectors.toMap(Locale::getTag, Function.identity()));
    }

    private I18n d(JsonObject jsonObject) {
        I18n i18n = new I18n();
        this.o().forEach((tag, locale) -> {
            JsonElement element = jsonObject.get(tag);
            if (element != null && !element.isJsonNull() && !element.getAsString().isEmpty()) {
                i18n.getTranslations().add(new Translation((Locale)locale, element.getAsString(), i18n));
            }
        });
        return i18n;
    }

    private Language e(JsonObject jsonObject) {
        Map<String, Locale> locales = this.o();
        I18n i18n = new I18n();
        i18n.getTranslations().add(new Translation(locales.get("fr"), jsonObject.get("fr").getAsString(), i18n));
        i18n.getTranslations().add(new Translation(locales.get("en"), jsonObject.get("en").getAsString(), i18n));
        return new Language(jsonObject.get("id").getAsInt(), i18n, new Image(Paths.get("images/flags", jsonObject.get("code").getAsString() + ".png")));
    }

    private List<Language> b(JsonArray jsonArray) {
        LinkedList<Language> result = new LinkedList<Language>();
        List entities = this.l.createNamedQuery("Language.findAll", Language.class).getResultList();
        jsonArray.forEach(e2 -> {
            JsonObject jsonObject = e2.getAsJsonObject();
            Optional<Language> optional = entities.stream().filter(language -> Objects.equals(language.getRid(), jsonObject.get("id").getAsInt())).findAny();
            Language language2 = optional.orElseGet(() -> this.e(jsonObject));
            result.add(language2);
        });
        return result;
    }

    private Genre f(JsonObject jsonObject) {
        Map<String, Locale> locales = this.o();
        I18n i18n = new I18n();
        i18n.getTranslations().add(new Translation(locales.get("fr"), jsonObject.get("fr").getAsString(), i18n));
        i18n.getTranslations().add(new Translation(locales.get("en"), jsonObject.get("en").getAsString(), i18n));
        return new Genre(jsonObject.get("id").getAsInt(), i18n);
    }

    private List<Genre> c(JsonArray jsonArray) {
        LinkedList<Genre> result = new LinkedList<Genre>();
        List entities = this.l.createNamedQuery("Genre.findAll", Genre.class).getResultList();
        jsonArray.forEach(e2 -> {
            JsonObject jsonObject = e2.getAsJsonObject();
            Optional<Genre> optional = entities.stream().filter(genre -> Objects.equals(genre.getRid(), jsonObject.get("id").getAsInt())).findAny();
            Genre genre2 = optional.orElseGet(() -> this.f(jsonObject));
            result.add(genre2);
        });
        return result;
    }

    private Developer g(JsonObject jsonObject) {
        return new Developer(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
    }

    private Developer h(JsonObject jsonObject) {
        int rid = jsonObject.get("id").getAsInt();
        if (rid == 0) {
            return null;
        }
        try {
            return (Developer)this.l.createNamedQuery("Developer.findByRID", Developer.class).setParameter("rid", (Object)rid).getSingleResult();
        }
        catch (NoResultException ex) {
            return this.g(jsonObject);
        }
    }

    private Publisher i(JsonObject jsonObject) {
        return new Publisher(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
    }

    private Publisher j(JsonObject jsonObject) {
        int rid = jsonObject.get("id").getAsInt();
        if (rid == 0) {
            return null;
        }
        try {
            return (Publisher)this.l.createNamedQuery("Publisher.findByRID", Publisher.class).setParameter("rid", (Object)rid).getSingleResult();
        }
        catch (NoResultException ex) {
            return this.i(jsonObject);
        }
    }

    private Series k(JsonObject jsonObject) {
        return new Series(jsonObject.get("id").getAsInt(), jsonObject.get("name").getAsString());
    }

    private List<Series> d(JsonArray jsonArray) {
        LinkedList<Series> result = new LinkedList<Series>();
        List entities = this.l.createNamedQuery("Series.findAll", Series.class).getResultList();
        jsonArray.forEach(e2 -> {
            JsonObject jsonObject = e2.getAsJsonObject();
            Optional<Series> optional = entities.stream().filter(series -> Objects.equals(series.getRid(), jsonObject.get("id").getAsInt())).findAny();
            Series series2 = optional.orElseGet(() -> this.k(jsonObject));
            result.add(series2);
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GameFile p() throws Exception {
        try {
            Game game;
            this.l = org.romstation.application.b.c();
            try {
                game = (Game)this.l.createNamedQuery("Game.findByRID", Game.class).setParameter("rid", (Object)this.c.b().get("id").getAsInt()).getSingleResult();
            }
            catch (NoResultException ex) {
                game = this.a(this.c.b());
            }
            GameFile gameFile = this.a(game);
            game.getFiles().add(gameFile);
            this.l.getTransaction().begin();
            this.l.persist((Object)game);
            this.l.getTransaction().commit();
            GameFile gameFile2 = gameFile;
            return gameFile2;
        }
        finally {
            if (this.l != null) {
                this.l.close();
            }
        }
    }

    protected /* synthetic */ Object call() throws Exception {
        return this.g();
    }
}

