/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.media.MediaType;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.romstation.application.RomStation;
import org.romstation.application.cR;
import org.romstation.application.view.controller.RomStationController;

public class BrowserContextMenu
implements ShowContextMenuCallback {
    private final ContextMenu a;
    private final BrowserView b;
    private final ResourceBundle c;

    public BrowserContextMenu(BrowserView browserView) {
        this.b = browserView;
        this.a = new ContextMenu();
        this.c = RomStation.d();
    }

    public void on(ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action action) {
        Platform.runLater(() -> {
            this.a.hide();
            this.a.getItems().clear();
            this.updateContextMenu(params);
            if (!this.a.getItems().isEmpty()) {
                Point location = params.location();
                Point2D point2D = this.b.localToScreen((double)location.x(), (double)location.y());
                this.a.show((Node)this.b, point2D.getX(), point2D.getY());
            }
            action.close();
        });
    }

    private void updateContextMenu(ShowContextMenuCallback.Params params) {
        params.browser().mainFrame().ifPresent(frame -> {
            MenuItem copyLocationMenuItem;
            if (!params.spellCheckMenu().misspelledWord().isEmpty()) {
                if (!params.spellCheckMenu().dictionarySuggestions().isEmpty()) {
                    params.spellCheckMenu().dictionarySuggestions().forEach(suggestion -> {
                        MenuItem menuItem = new MenuItem(suggestion);
                        menuItem.getStyleClass().addAll((Object[])new String[]{"dictionary", "suggestion"});
                        menuItem.setOnAction(actionEvent -> params.browser().replaceMisspelledWord(suggestion));
                        this.a.getItems().add((Object)menuItem);
                    });
                }
                MenuItem addDictionaryMenuItem = new MenuItem(this.c.getString("browser.contextMenu.dictionary.add"));
                addDictionaryMenuItem.setOnAction(actionEvent -> params.browser().engine().spellChecker().customDictionary().add(params.spellCheckMenu().misspelledWord()));
                this.a.getItems().add((Object)addDictionaryMenuItem);
            }
            if (frame.isCommandEnabled(EditorCommand.Name.INSERT_TEXT)) {
                if (!this.a.getItems().isEmpty()) {
                    this.a.getItems().add((Object)new SeparatorMenuItem());
                }
                MenuItem undoMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.undo"));
                undoMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.undo()));
                undoMenuItem.setDisable(!frame.isCommandEnabled(EditorCommand.Name.UNDO));
                this.a.getItems().addAll((Object[])new MenuItem[]{undoMenuItem, new SeparatorMenuItem()});
                MenuItem cutMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.cut"));
                cutMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.cut()));
                cutMenuItem.setDisable(!frame.isCommandEnabled(EditorCommand.Name.CUT));
                this.a.getItems().add((Object)cutMenuItem);
                MenuItem copyMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.copy"));
                copyMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.copy()));
                copyMenuItem.setDisable(!frame.isCommandEnabled(EditorCommand.Name.COPY));
                this.a.getItems().add((Object)copyMenuItem);
                MenuItem pasteMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.paste"));
                pasteMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.paste()));
                pasteMenuItem.setDisable(!frame.isCommandEnabled(EditorCommand.Name.PASTE));
                this.a.getItems().add((Object)pasteMenuItem);
                MenuItem deleteMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.delete"));
                deleteMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.delete()));
                deleteMenuItem.setDisable(!frame.isCommandEnabled(EditorCommand.Name.DELETE));
                this.a.getItems().addAll((Object[])new MenuItem[]{deleteMenuItem, new SeparatorMenuItem()});
                MenuItem selectAllMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.selectAll"));
                selectAllMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.selectAll()));
                this.a.getItems().addAll((Object[])new MenuItem[]{selectAllMenuItem});
            } else if (frame.isCommandEnabled(EditorCommand.Name.COPY)) {
                MenuItem copyMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.copy"));
                copyMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.copy()));
                this.a.getItems().add((Object)copyMenuItem);
                MenuItem selectAllMenuItem = new MenuItem(this.c.getString("browser.contextMenu.text.selectAll"));
                selectAllMenuItem.setOnAction(actionEvent -> frame.execute(EditorCommand.selectAll()));
                this.a.getItems().addAll((Object[])new MenuItem[]{selectAllMenuItem});
            }
            if (!params.linkUrl().isEmpty()) {
                if (!this.a.getItems().isEmpty()) {
                    this.a.getItems().add((Object)new SeparatorMenuItem());
                }
                MenuItem openNewTabMenuItem = new MenuItem(this.c.getString("browser.contextMenu.link.openNewTab"));
                openNewTabMenuItem.setOnAction(actionEvent -> RomStationController.a.post((Object)new cR(params.linkUrl())));
                this.a.getItems().add((Object)openNewTabMenuItem);
                MenuItem openNewWindowMenuItem = new MenuItem(this.c.getString("browser.contextMenu.link.openNewWindow"));
                openNewWindowMenuItem.setOnAction(actionEvent -> {
                    try {
                        Desktop.getDesktop().browse(new URI(params.linkUrl()));
                    }
                    catch (IOException | URISyntaxException exception) {
                        RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                    }
                });
                this.a.getItems().add((Object)openNewWindowMenuItem);
                copyLocationMenuItem = new MenuItem(this.c.getString("browser.contextMenu.link.copyLocation"));
                copyLocationMenuItem.setOnAction(actionEvent -> {
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(params.linkUrl());
                    clipboardContent.putUrl(params.linkUrl());
                    clipboard.setContent((Map)clipboardContent);
                });
                this.a.getItems().add((Object)copyLocationMenuItem);
            }
            if (params.mediaType() == MediaType.IMAGE) {
                if (!this.a.getItems().isEmpty()) {
                    this.a.getItems().add((Object)new SeparatorMenuItem());
                }
                MenuItem showMenuItem = new MenuItem(this.c.getString("browser.contextMenu.image.show"));
                showMenuItem.setOnAction(actionEvent -> params.browser().navigation().loadUrl(params.srcUrl()));
                this.a.getItems().add((Object)showMenuItem);
                MenuItem copyMenuItem = new MenuItem(this.c.getString("browser.contextMenu.image.copy"));
                copyMenuItem.setOnAction(actionEvent -> {
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putImage(new Image(params.srcUrl()));
                    clipboard.setContent((Map)clipboardContent);
                });
                this.a.getItems().add((Object)copyMenuItem);
                copyLocationMenuItem = new MenuItem(this.c.getString("browser.contextMenu.image.copyLocation"));
                copyLocationMenuItem.setOnAction(actionEvent -> {
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(params.srcUrl());
                    clipboardContent.putUrl(params.srcUrl());
                    clipboard.setContent((Map)clipboardContent);
                });
                this.a.getItems().add((Object)copyLocationMenuItem);
            }
        });
    }

    public ContextMenu getContextMenu() {
        return this.a;
    }

    public BrowserView getBrowserView() {
        return this.b;
    }
}

