/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import org.romstation.application.RomStation;
import org.romstation.application.aU;
import org.romstation.application.database.entity.System;

public class SystemComboBox
extends HBox {
    @FXML
    private ComboBox<System> comboBox;
    @FXML
    private MenuButton menuButton;
    @FXML
    private MenuItem editMenuItem;
    @FXML
    private MenuItem clearMenuItem;
    @FXML
    private ResourceBundle resources;

    public SystemComboBox() {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/control/systemComboBox.fxml"));
            fxmlLoader.setResources(RomStation.d());
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public ComboBox<System> getComboBox() {
        return this.comboBox;
    }

    @FXML
    private void initialize() {
        this.editMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
        this.clearMenuItem.disableProperty().bind((ObservableValue)this.comboBox.valueProperty().isNull());
    }

    @FXML
    private void create() {
        aU dialog = new aU(new System());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(system -> {
            this.comboBox.getItems().add(system);
            this.comboBox.setValue(system);
        });
    }

    @FXML
    private void edit() {
        aU dialog = new aU((System)this.comboBox.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(system -> {
            this.comboBox.getItems().setAll(new LinkedList(this.comboBox.getItems()));
            this.comboBox.getSelectionModel().select(system);
        });
    }

    @FXML
    private void clear() {
        this.comboBox.getSelectionModel().clearSelection();
    }
}

