/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.control.cell;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.beans.NamedArg;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class DateTableCell<S>
extends TableCell<S, Long> {
    private final StringProperty a;

    public DateTableCell(@NamedArg(value="pattern") String pattern) {
        this.a = new SimpleStringProperty(pattern);
        this.getStyleClass().add((Object)"date");
    }

    public StringProperty a() {
        return this.a;
    }

    public String b() {
        return (String)this.a.get();
    }

    public void a(String pattern) {
        this.a.set((Object)pattern);
    }

    protected void a(Long item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
        } else if (item == 0L) {
            this.setText(null);
        } else {
            LocalDateTime date = Instant.ofEpochSecond(item).atZone(ZoneId.systemDefault()).toLocalDateTime();
            this.setText(date.format(DateTimeFormatter.ofPattern((String)this.a.get())));
        }
    }

    protected /* synthetic */ void updateItem(Object object, boolean bl2) {
        this.a((Long)object, bl2);
    }

    public static class Factory<S>
    implements Callback<TableColumn<S, Long>, DateTableCell> {
        private final StringProperty a;

        public Factory(@NamedArg(value="pattern") String pattern) {
            this.a = new SimpleStringProperty(pattern);
        }

        public DateTableCell a(TableColumn<S, Long> param) {
            return new DateTableCell((String)this.a.get());
        }

        public /* synthetic */ Object call(Object object) {
            return this.a((TableColumn)object);
        }
    }
}

