/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.romstation.application.RomStation;
import org.romstation.application.aX;
import org.romstation.application.ao;
import org.romstation.application.av;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.task.g;
import org.romstation.application.view.control.ApplicationAlert;

public class EmulatorFilesPaneController {
    private final Emulator a;
    @FXML
    private Button deleteButton;
    @FXML
    private Button editButton;
    @FXML
    private Button explorerButton;
    @FXML
    private Button copyButton;
    @FXML
    private TableView<EmulatorFile> tableView;
    @FXML
    private TableColumn<EmulatorFile, Integer> idTableColumn;
    @FXML
    private TableColumn<EmulatorFile, String> nameTableColumn;
    @FXML
    private TableColumn<EmulatorFile, Integer> profilesTableColumn;
    @FXML
    private ResourceBundle resources;

    public EmulatorFilesPaneController(Emulator emulator) {
        this.a = emulator;
    }

    public TableView<EmulatorFile> a() {
        return this.tableView;
    }

    @FXML
    private void initialize() {
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.explorerButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.copyButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.profilesTableColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((EmulatorFile)param.getValue()).getProfiles().size()));
        this.tableView.getItems().setAll(this.a.getFiles());
    }

    @FXML
    private void create() {
        EmulatorFile emulatorFile = new EmulatorFile();
        emulatorFile.setEmulator(this.a);
        aX dialog = new aX(emulatorFile);
        Optional optional = dialog.showAndWait();
        optional.ifPresent(arg_0 -> this.tableView.getItems().add(arg_0));
    }

    @FXML
    private void importFile() {
        ao dialog = new ao(this.a);
        dialog.showAndWait().ifPresent(arg_0 -> this.tableView.getItems().add(arg_0));
    }

    @FXML
    private void delete() {
        ApplicationAlert alert = new ApplicationAlert(this.resources.getString("emulatorFile.delete.alert.header"), this.resources.getString("emulatorFile.delete.alert.content"), Alert.AlertType.CONFIRMATION);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            g emulatorFileDeleteTask = new g((List<EmulatorFile>)this.tableView.getSelectionModel().getSelectedItems());
            Thread thread = new Thread((Runnable)((Object)emulatorFileDeleteTask));
            av<List<EmulatorFile>> dialog = new av<List<EmulatorFile>>(emulatorFileDeleteTask, "delete");
            thread.start();
            Optional dialogResult = dialog.showAndWait();
            dialogResult.ifPresent(arg_0 -> this.tableView.getItems().removeAll(arg_0));
        }
    }

    @FXML
    private void edit() {
        aX dialog = new aX((EmulatorFile)this.tableView.getSelectionModel().getSelectedItem());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(emulatorFile -> this.tableView.refresh());
    }

    @FXML
    private void openExplorer() {
        EmulatorFile selectedItem = (EmulatorFile)this.tableView.getSelectionModel().getSelectedItem();
        if (selectedItem.getDirectory() != null) {
            try {
                Desktop.getDesktop().open(new File(selectedItem.getDirectory()));
            }
            catch (IOException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    @FXML
    private void copy() {
        this.tableView.getItems().add((Object)new EmulatorFile((EmulatorFile)this.tableView.getSelectionModel().getSelectedItem()));
    }
}

