/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javax.persistence.EntityManager;
import org.romstation.application.aG;
import org.romstation.application.aw;
import org.romstation.application.ax;
import org.romstation.application.b;
import org.romstation.application.database.entity.I18n;
import org.romstation.application.database.entity.Locale;
import org.romstation.application.database.entity.Translation;

public class TranslationsPaneController {
    private final I18n a;
    private final ObservableList<Locale> b = FXCollections.observableList(new LinkedList());
    private final BooleanProperty c = new SimpleBooleanProperty();
    @FXML
    private Button addButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button editButton;
    @FXML
    private TableView<Translation> tableView;
    @FXML
    private ResourceBundle resources;

    public TranslationsPaneController(I18n i18n) {
        this.a = i18n;
        EntityManager entityManager = org.romstation.application.b.c();
        this.b.setAll((Collection)entityManager.createNamedQuery("Locale.findAll", Locale.class).getResultList());
        this.b.sort(Comparator.comparing(genre -> genre.getName().getDefaultString()));
        entityManager.close();
    }

    public I18n a() {
        return this.a;
    }

    public boolean b() {
        return this.c.get();
    }

    public BooleanProperty c() {
        return this.c;
    }

    public void a(boolean useTextArea) {
        this.c.set(useTextArea);
    }

    public TableView<Translation> d() {
        return this.tableView;
    }

    private List<Locale> e() {
        LinkedList<Locale> result = new LinkedList<Locale>((Collection<Locale>)this.b);
        result.removeAll(this.tableView.getItems().stream().map(Translation::getLocale).collect(Collectors.toList()));
        return result;
    }

    @FXML
    private void initialize() {
        this.addButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getItems()).isEqualTo((ObservableNumberValue)Bindings.size(this.b)));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getItems().setAll(this.a.getTranslations());
    }

    @FXML
    private void add() {
        aG dialog = new aG(this.e());
        dialog.showAndWait().ifPresent(item -> {
            Optional<String> optional = this.a((String)null);
            optional.ifPresent(string -> this.tableView.getItems().add((Object)new Translation((Locale)item.get(0), (String)string, this.a)));
        });
    }

    @FXML
    private void delete() {
        this.tableView.getItems().removeAll((Collection)this.tableView.getSelectionModel().getSelectedItems());
    }

    @FXML
    private void edit() {
        Translation selectedItem = (Translation)this.tableView.getSelectionModel().getSelectedItem();
        Optional<String> optional = this.a(selectedItem.getString());
        optional.ifPresent(string -> {
            selectedItem.setString((String)string);
            this.tableView.refresh();
        });
    }

    private Optional<String> a(String text) {
        if (this.b()) {
            return this.c(text);
        }
        return this.b(text);
    }

    private Optional<String> b(String text) {
        ax dialog = new ax(this.resources.getString("i18n.editor.edit.dialog.header"), text);
        return dialog.showAndWait();
    }

    private Optional<String> c(String text) {
        aw dialog = new aw(this.resources.getString("i18n.editor.edit.dialog.header"), text);
        dialog.setResizable(true);
        return dialog.showAndWait();
    }
}

