/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.browser;

import com.google.common.eventbus.Subscribe;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.browser.callback.input.MoveMouseWheelCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressMouseCallback;
import com.teamdev.jxbrowser.browser.event.FaviconChanged;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.dom.PointInspection;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.event.LoadFinished;
import com.teamdev.jxbrowser.navigation.event.LoadStarted;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.graphics.BitmapImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import org.romstation.application.D;
import org.romstation.application.E;
import org.romstation.application.RomStation;
import org.romstation.application.api.a;
import org.romstation.application.cP;
import org.romstation.application.cQ;
import org.romstation.application.cR;
import org.romstation.application.ci;
import org.romstation.application.cj;
import org.romstation.application.network.b;
import org.romstation.application.view.control.BrowserContextMenu;
import org.romstation.application.view.controller.RomStationController;

public class BrowserTabController
extends Tab {
    private final Browser a;
    private final BrowserView b;
    private final BrowserContextMenu c;
    private Timeline d;
    @FXML
    private BorderPane borderPane;
    @FXML
    private ImageView progressImageView;
    @FXML
    private ImageView faviconImageView;
    @FXML
    private Button backButton;
    @FXML
    private Button forwardButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button reloadButton;
    @FXML
    private TextField urlTextField;

    public BrowserTabController(Browser browser) {
        this(BrowserView.newInstance((Browser)browser));
    }

    public BrowserTabController(BrowserView browserView) {
        this.a = browserView.getBrowser();
        this.b = browserView;
        this.c = new BrowserContextMenu(browserView);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(((Object)((Object)this)).getClass().getResource("/fxml/browser/browserTab.fxml"));
        fxmlLoader.setResources(RomStation.d());
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        this.d = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)125.0), actionEvent -> {
            if (this.progressImageView.getRotate() > 360.0) {
                this.progressImageView.setRotate(0.0);
            }
            this.progressImageView.setRotate(this.progressImageView.getRotate() + 45.0);
        }, new KeyValue[0])});
        this.d.setCycleCount(-1);
        this.a.set(ShowContextMenuCallback.class, (Callback)this.c);
        this.a.set(PressKeyCallback.class, (Callback)((PressKeyCallback)this::a));
        this.a.set(PressMouseCallback.class, (Callback)((PressMouseCallback)this::a));
        this.a.set(MoveMouseWheelCallback.class, (Callback)((MoveMouseWheelCallback)this::a));
        this.a.set(StartDownloadCallback.class, (Callback)((StartDownloadCallback)(params, tell) -> tell.cancel()));
        this.a.set(OpenPopupCallback.class, (Callback)((OpenPopupCallback)params -> {
            Platform.runLater(() -> RomStationController.a.post((Object)new cQ(params.popupBrowser(), true)));
            return OpenPopupCallback.Response.proceed();
        }));
        this.a.on(TitleChanged.class, event -> {
            String title = event.title();
            Platform.runLater(() -> this.setText(title));
        });
        this.a.navigation().on(LoadStarted.class, event -> Platform.runLater(() -> {
            this.faviconImageView.setVisible(false);
            this.d.play();
            this.progressImageView.setVisible(true);
            this.reloadButton.setVisible(false);
            this.stopButton.setVisible(true);
        }));
        this.a.navigation().on(LoadFinished.class, event -> {
            RomStationController.a.post((Object)new cP(event.navigation().browser()));
            Platform.runLater(() -> {
                this.progressImageView.setVisible(false);
                this.d.stop();
                this.faviconImageView.setVisible(true);
                this.stopButton.setVisible(false);
                this.reloadButton.setVisible(true);
            });
        });
        this.a.navigation().on(NavigationFinished.class, event -> {
            if (event.hasCommitted() && event.isInMainFrame()) {
                boolean canGoBack = event.frame().browser().navigation().currentEntryIndex() == 1;
                boolean canGoForward = event.frame().browser().navigation().canGoForward();
                String url = event.url();
                Platform.runLater(() -> {
                    this.backButton.setDisable(canGoBack);
                    this.forwardButton.setDisable(!canGoForward);
                    this.urlTextField.setText(url);
                });
            }
        });
        this.a.on(FaviconChanged.class, event -> {
            Bitmap favicon = event.favicon();
            Platform.runLater(() -> this.faviconImageView.setImage(BitmapImage.toToolkit((Bitmap)favicon)));
        });
        this.a.set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
            try {
                JsObject window;
                URL url = new URL(params.frame().browser().url());
                if (url.getHost().equals(org.romstation.application.network.b.a()) && (window = (JsObject)params.frame().executeJavaScript("window")) != null) {
                    window.putProperty("romstation_api", (Object)org.romstation.application.api.a.getInstance());
                }
            }
            catch (MalformedURLException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
            return InjectJsCallback.Response.proceed();
        }));
        this.urlTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Platform.runLater(() -> this.urlTextField.selectAll());
            }
        });
        this.borderPane.setCenter((Node)this.b);
    }

    private void c() {
        RomStationController.a.unregister((Object)this);
        this.a.close();
    }

    @FXML
    private void onCloseRequest() {
        this.c();
    }

    @FXML
    private void closeTab() {
        this.a(this);
    }

    private void a(Tab tab) {
        Event.fireEvent((EventTarget)tab, (Event)new Event(Tab.TAB_CLOSE_REQUEST_EVENT));
        this.getTabPane().getTabs().remove((Object)tab);
    }

    @FXML
    private void closeOtherTabs() {
        this.getTabPane().getTabs().stream().filter(tab -> tab != this).collect(Collectors.toList()).forEach(this::a);
    }

    @FXML
    private void back() {
        if (this.a.navigation().canGoBack() && this.a.navigation().currentEntryIndex() > 1) {
            this.a.navigation().goBack();
        }
    }

    @FXML
    private void forward() {
        if (this.a.navigation().canGoForward()) {
            this.a.navigation().goForward();
        }
    }

    @FXML
    private void stop() {
        this.a.navigation().stop();
    }

    @FXML
    private void reload() {
        this.a.navigation().reload();
    }

    @FXML
    private void home() {
        this.a.navigation().loadUrl(org.romstation.application.network.b.b());
    }

    @FXML
    private void openNewTab() {
        RomStationController.a.post((Object)new cR(org.romstation.application.network.b.b(), true));
    }

    @FXML
    private void loadUrl() {
        this.a.navigation().loadUrl(this.urlTextField.getText());
    }

    @Subscribe
    private void a(cj event) {
        new Thread(() -> this.a.mainFrame().ifPresent(frame -> {
            JsObject window = (JsObject)frame.executeJavaScript("window");
            if (window != null && window.hasProperty("romstation_api") && window.hasProperty("refreshPage")) {
                window.call("refreshPage", new Object[0]);
            }
        })).start();
    }

    @Subscribe
    private void a(ci event) {
        new Thread(() -> this.a.mainFrame().ifPresent(frame -> {
            JsObject window = (JsObject)frame.executeJavaScript("window");
            if (window != null && window.hasProperty("romstation_api") && window.hasProperty("refreshPage")) {
                window.call("refreshPage", new Object[0]);
            }
        })).start();
    }

    private boolean a(KeyModifiers keyModifiers) {
        if (E.c() == D.MAC_OS) {
            return keyModifiers.isMetaDown();
        }
        return keyModifiers.isControlDown();
    }

    private PressKeyCallback.Response a(PressKeyCallback.Params params) {
        switch (params.event().keyCode()) {
            case KEY_CODE_ESCAPE: {
                this.a.navigation().stop();
                break;
            }
            case KEY_CODE_R: {
                if (!this.a(params.event().keyModifiers())) break;
                if (params.event().keyModifiers().isShiftDown()) {
                    this.a.navigation().reloadIgnoringCache();
                    break;
                }
                this.a.navigation().reload();
                break;
            }
            case KEY_CODE_F5: {
                if (this.a(params.event().keyModifiers())) {
                    this.a.navigation().reloadIgnoringCache();
                    break;
                }
                this.a.navigation().reload();
                break;
            }
            case KEY_CODE_NUMPAD0: 
            case KEY_CODE_0: {
                if (!this.a(params.event().keyModifiers())) break;
                this.a.zoom().reset();
                break;
            }
            case KEY_CODE_ADD: 
            case KEY_CODE_OEM_PLUS: {
                if (!this.a(params.event().keyModifiers())) break;
                this.a.zoom().in();
                break;
            }
            case KEY_CODE_SUBTRACT: 
            case KEY_CODE_OEM_MINUS: {
                if (!this.a(params.event().keyModifiers())) break;
                this.a.zoom().out();
            }
        }
        return PressKeyCallback.Response.proceed();
    }

    private PressMouseCallback.Response a(PressMouseCallback.Params params) {
        switch (params.event().button()) {
            case PRIMARY: {
                Platform.runLater(() -> this.c.getContextMenu().hide());
                if (!this.a(params.event().keyModifiers())) break;
            }
            case MIDDLE: {
                this.a.mainFrame().ifPresent(frame -> {
                    PointInspection pointInspection = frame.inspect(Point.of((int)params.event().location().x(), (int)params.event().location().y()));
                    if (!pointInspection.absoluteLinkUrl().isEmpty()) {
                        Platform.runLater(() -> RomStationController.a.post((Object)new cR(pointInspection.absoluteLinkUrl(), false)));
                    }
                });
            }
        }
        return PressMouseCallback.Response.proceed();
    }

    private MoveMouseWheelCallback.Response a(MoveMouseWheelCallback.Params params) {
        if (params.event().deltaY() != 0.0f && this.a(params.event().keyModifiers())) {
            if (params.event().deltaY() > 0.0f) {
                this.a.zoom().in();
            } else {
                this.a.zoom().out();
            }
        }
        return MoveMouseWheelCallback.Response.proceed();
    }

    public Browser a() {
        return this.a;
    }

    public BrowserView b() {
        return this.b;
    }
}

