/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.emulators;

import com.google.common.eventbus.Subscribe;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import javax.persistence.EntityManager;
import org.romstation.application.RomStation;
import org.romstation.application.X;
import org.romstation.application.Y;
import org.romstation.application.aA;
import org.romstation.application.aE;
import org.romstation.application.aW;
import org.romstation.application.aa;
import org.romstation.application.av;
import org.romstation.application.b;
import org.romstation.application.bc;
import org.romstation.application.be;
import org.romstation.application.cR;
import org.romstation.application.cW;
import org.romstation.application.ce;
import org.romstation.application.cg;
import org.romstation.application.ch;
import org.romstation.application.ci;
import org.romstation.application.ck;
import org.romstation.application.cl;
import org.romstation.application.cm;
import org.romstation.application.cn;
import org.romstation.application.co;
import org.romstation.application.cp;
import org.romstation.application.cq;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.task.f;
import org.romstation.application.task.z;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.SearchField;
import org.romstation.application.view.controller.ApplicationView;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.emulators.EmulatorsFiltersController;

public class EmulatorsController {
    private Timeline a;
    @FXML
    private BorderPane root;
    @FXML
    private Label searchResultLabel;
    @FXML
    private SearchField nameSearchField;
    @FXML
    private EmulatorsFiltersController filtersController;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        this.nameSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.a.playFromStart());
        this.a = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), event -> this.filtersController.a(this.nameSearchField.getText()), new KeyValue[0])});
    }

    private void a(Emulator emulator) {
        List<EmulatorProfile> emulatorProfiles = emulator.getFiles().stream().flatMap(emulatorFile -> emulatorFile.getProfiles().stream()).filter(profile -> profile.getSystems().isEmpty()).sorted(Comparator.comparing(EmulatorProfile::getName, Comparator.nullsFirst(String::compareToIgnoreCase))).collect(Collectors.toList());
        switch (emulatorProfiles.size()) {
            case 0: {
                return;
            }
            case 1: {
                cW.a(new z(emulatorProfiles.get(0), new String[0]));
                return;
            }
        }
        aA dialog = new aA(emulatorProfiles);
        dialog.showAndWait().ifPresent(emulatorProfile -> cW.a(new z((EmulatorProfile)emulatorProfile, new String[0])));
    }

    @Subscribe
    private void a(cg event) {
        this.root.setVisible(event.a() == ApplicationView.EMULATORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    private void a(ce event) {
        Path root = Paths.get("", new String[0]).toAbsolutePath().getParent();
        if (Files.exists(root.resolve("database.sqlite"), new LinkOption[0]) && Files.notExists(root.resolve("imported"), new LinkOption[0]) && Files.notExists(root.resolve("emulators_imported"), new LinkOption[0])) {
            try {
                aa emulatorScannerTask = new aa(root);
                emulatorScannerTask.run();
                List emulators = (List)emulatorScannerTask.get();
                if (!emulators.isEmpty()) {
                    Y emulatorImporterTask = new Y(emulators);
                    Thread thread = new Thread((Runnable)((Object)emulatorImporterTask));
                    av<List<Emulator>> taskDialog = new av<List<Emulator>>(emulatorImporterTask);
                    thread.start();
                    taskDialog.showAndWait();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                try {
                    Files.createFile(root.resolve("emulators_imported"), new FileAttribute[0]);
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        this.filtersController.b();
        this.filtersController.a();
    }

    @Subscribe
    private void a(cq event) {
        EntityManager entityManager = b.c();
        long count = (Long)entityManager.createNamedQuery("Emulator.countAll", Long.class).getSingleResult();
        entityManager.close();
        String message = MessageFormat.format(this.resources.getString("emulators.search.result"), event.a().size(), count);
        this.searchResultLabel.setText(message);
    }

    @Subscribe
    private void a(cm event) {
        this.a(event.a());
    }

    @Subscribe
    private void a(ck event) {
        ApplicationAlert alert = new ApplicationAlert(Alert.AlertType.CONFIRMATION);
        alert.setHeaderText(this.resources.getString("emulator.delete.alert.header"));
        alert.setContentText(this.resources.getString("emulator.delete.alert.content"));
        Optional alertResult = alert.showAndWait();
        if (alertResult.isPresent() && alertResult.get() == ButtonType.OK) {
            f emulatorDeleteTask = new f(event.a());
            Thread thread = new Thread((Runnable)((Object)emulatorDeleteTask));
            av<List<Emulator>> dialog = new av<List<Emulator>>(emulatorDeleteTask, "delete");
            thread.start();
            Optional dialogResult = dialog.showAndWait();
            dialogResult.ifPresent(items -> {
                if (!items.isEmpty()) {
                    RomStationController.a.post((Object)new ci());
                }
            });
        }
    }

    @Subscribe
    private void a(cl event) {
        aW dialog = new aW(event.a());
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            EntityManager entityManager = b.c();
            entityManager.getTransaction().begin();
            entityManager.merge(result.get());
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new ci());
        } else {
            RomStationController.a.post((Object)new cp());
        }
    }

    @Subscribe
    private void a(cn event) {
        Emulator emulator = event.a();
        if (emulator.getDirectory() != null) {
            try {
                Desktop.getDesktop().open(new File(emulator.getDirectory()));
            }
            catch (Exception exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    @Subscribe
    private void a(co event) {
        Emulator emulator = event.a();
        aE dialog = new aE(emulator.getLinks());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(link -> {
            if (link.isExternal()) {
                try {
                    Desktop.getDesktop().browse(new URI(link.getLocation()));
                }
                catch (Exception exception) {
                    RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                }
            } else {
                RomStationController.a.post((Object)new cR(link.getLocation(), true));
                RomStationController.a.post((Object)new ch(ApplicationView.BROWSER));
            }
        });
    }

    @FXML
    private void create() {
        aW dialog = new aW(new Emulator());
        Optional optional = dialog.showAndWait();
        optional.ifPresent(entity -> {
            EntityManager entityManager = b.c();
            entityManager.getTransaction().begin();
            entityManager.merge(entity);
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new ci());
        });
    }

    @FXML
    private void download() {
        RomStationController.a.post((Object)new cR(org.romstation.application.network.b.b() + "/emulators", true));
        RomStationController.a.post((Object)new ch(ApplicationView.BROWSER));
    }

    @FXML
    private void importLegacy() {
        be romstationDirectoryChooserDialog = new be();
        romstationDirectoryChooserDialog.showAndWait().ifPresent(path -> {
            try {
                aa emulatorScannerTask = new aa((Path)path);
                emulatorScannerTask.run();
                List emulators = (List)emulatorScannerTask.get();
                bc emulatorImporterDialog = new bc(emulators);
                emulatorImporterDialog.showAndWait().ifPresent(items -> {
                    Y task = new Y((List<X>)items);
                    Thread thread = new Thread((Runnable)((Object)task));
                    av<List<Emulator>> taskDialog = new av<List<Emulator>>(task);
                    thread.start();
                    Optional dialogResult = taskDialog.showAndWait();
                    dialogResult.ifPresent(importedGames -> {
                        if (!importedGames.isEmpty()) {
                            RomStationController.a.post((Object)new ci());
                        }
                    });
                });
            }
            catch (Exception exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        });
    }

    public Node a() {
        return this.root;
    }
}

