/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.emulators.table;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.romstation.application.ck;
import org.romstation.application.cl;
import org.romstation.application.cm;
import org.romstation.application.cn;
import org.romstation.application.co;
import org.romstation.application.cq;
import org.romstation.application.database.entity.Emulator;
import org.romstation.application.database.entity.System;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.emulators.table.EmulatorTableRow;

public class EmulatorsTableViewController {
    @FXML
    private TableView<Emulator> tableView;
    @FXML
    private TableColumn<Emulator, Integer> idColumn;
    @FXML
    private TableColumn<Emulator, String> nameColumn;
    @FXML
    private TableColumn<Emulator, Integer> filesColumn;
    @FXML
    private TableColumn<Emulator, List<System>> systemsColumn;
    @FXML
    private Button launchButton;
    @FXML
    private Button editButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button openExplorerButton;
    @FXML
    private Button showLinksButton;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setRowFactory((Callback)new EmulatorTableRow.Factory());
        this.filesColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((Emulator)param.getValue()).getFiles().size()));
        this.launchButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.openExplorerButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.showLinksButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
    }

    @Subscribe
    private void a(cq event) {
        this.tableView.getItems().setAll(event.a());
        this.tableView.sort();
    }

    @FXML
    private void launch(ActionEvent actionEvent) {
        RomStationController.a.post((Object)new cm((Emulator)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void edit(ActionEvent actionEvent) {
        RomStationController.a.post((Object)new cl((Emulator)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void delete(ActionEvent actionEvent) {
        RomStationController.a.post((Object)new ck((List<Emulator>)this.tableView.getSelectionModel().getSelectedItems()));
    }

    @FXML
    private void openExplorer(ActionEvent actionEvent) {
        RomStationController.a.post((Object)new cn((Emulator)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void showLinks(ActionEvent actionEvent) {
        RomStationController.a.post((Object)new co((Emulator)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void keyPressed(KeyEvent keyEvent) {
        if (!this.tableView.getSelectionModel().isEmpty()) {
            switch (keyEvent.getCode()) {
                case ENTER: {
                    RomStationController.a.post((Object)new cm((Emulator)this.tableView.getSelectionModel().getSelectedItem()));
                    break;
                }
                case DELETE: {
                    RomStationController.a.post((Object)new ck((List<Emulator>)this.tableView.getSelectionModel().getSelectedItems()));
                }
            }
        }
    }
}

