/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.library;

import com.google.common.eventbus.Subscribe;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import javax.persistence.EntityManager;
import org.romstation.application.E;
import org.romstation.application.RomStation;
import org.romstation.application.aA;
import org.romstation.application.aB;
import org.romstation.application.aE;
import org.romstation.application.aZ;
import org.romstation.application.ab;
import org.romstation.application.ac;
import org.romstation.application.ad;
import org.romstation.application.ag;
import org.romstation.application.an;
import org.romstation.application.aq;
import org.romstation.application.av;
import org.romstation.application.az;
import org.romstation.application.b;
import org.romstation.application.bX;
import org.romstation.application.bY;
import org.romstation.application.bd;
import org.romstation.application.be;
import org.romstation.application.cA;
import org.romstation.application.cB;
import org.romstation.application.cE;
import org.romstation.application.cR;
import org.romstation.application.cV;
import org.romstation.application.cW;
import org.romstation.application.ce;
import org.romstation.application.cf;
import org.romstation.application.cg;
import org.romstation.application.ch;
import org.romstation.application.cj;
import org.romstation.application.cr;
import org.romstation.application.cs;
import org.romstation.application.cx;
import org.romstation.application.cy;
import org.romstation.application.cz;
import org.romstation.application.database.entity.EmulatorFile;
import org.romstation.application.database.entity.EmulatorProfile;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.GameFile;
import org.romstation.application.database.entity.GameProfile;
import org.romstation.application.network.InvalidServerResponseException;
import org.romstation.application.network.NetworkOfflineException;
import org.romstation.application.network.ServerResponseException;
import org.romstation.application.network.a;
import org.romstation.application.network.d;
import org.romstation.application.network.f;
import org.romstation.application.network.g;
import org.romstation.application.task.h;
import org.romstation.application.task.i;
import org.romstation.application.task.l;
import org.romstation.application.task.m;
import org.romstation.application.task.z;
import org.romstation.application.view.control.ApplicationAlert;
import org.romstation.application.view.control.SearchField;
import org.romstation.application.view.controller.ApplicationView;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.library.GameContextMenu;
import org.romstation.application.view.controller.library.LibraryView;
import org.romstation.application.view.controller.library.filters.LibraryFiltersController;

public class LibraryController {
    private static GameContextMenu a;
    private Timeline b;
    @FXML
    private BorderPane root;
    @FXML
    private Label searchResultLabel;
    @FXML
    private ToggleGroup viewToggleGroup;
    @FXML
    private ToggleButton tableViewToggle;
    @FXML
    private ToggleButton gridViewToggle;
    @FXML
    private SearchField titleSearchField;
    @FXML
    private LibraryFiltersController filtersController;
    @FXML
    private ResourceBundle resources;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        switch (LibraryView.valueOf(RomStation.c().getProperty("library.view"))) {
            case TABLE_VIEW: {
                this.viewToggleGroup.selectToggle((Toggle)this.tableViewToggle);
                break;
            }
            case GRID_VIEW: {
                this.viewToggleGroup.selectToggle((Toggle)this.gridViewToggle);
            }
        }
        this.viewToggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.viewToggleGroup.selectToggle(oldValue);
            }
        });
        this.titleSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.b.playFromStart());
        this.b = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), event -> this.filtersController.a(this.titleSearchField.getText()), new KeyValue[0])});
    }

    public static GameContextMenu a() {
        if (a == null) {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(LibraryController.class.getResource("/fxml/library/contextMenu.fxml"));
            fxmlLoader.setResources(RomStation.d());
            try {
                fxmlLoader.load();
                a = (GameContextMenu)fxmlLoader.getController();
            }
            catch (IOException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return a;
    }

    private void a(Game game, String ... arguments) {
        List<GameProfile> gameProfiles = game.getFiles().stream().flatMap(gameFile -> gameFile.getProfiles().stream()).collect(Collectors.toList());
        switch (gameProfiles.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.a((GameProfile)gameProfiles.get(0), arguments);
                return;
            }
        }
        aB dialog = new aB(gameProfiles);
        dialog.showAndWait().ifPresent(gameProfile -> this.a((GameProfile)gameProfile, arguments));
    }

    private void a(GameFile gameFile, String ... arguments) {
        switch (gameFile.getProfiles().size()) {
            case 0: {
                return;
            }
            case 1: {
                this.a(gameFile.getProfiles().get(0), arguments);
                return;
            }
        }
        aB dialog = new aB(gameFile.getProfiles());
        dialog.showAndWait().ifPresent(gameProfile -> this.a((GameProfile)gameProfile, arguments));
    }

    private void a(GameProfile gameProfile, String ... arguments) {
        Game game = gameProfile.getGameFile().getGame();
        if (game.getSystem() == null) {
            return;
        }
        EntityManager entityManager = org.romstation.application.b.c();
        List emulatorProfiles = entityManager.createQuery("select profile from EmulatorProfile profile where :system member of profile.systems", EmulatorProfile.class).setParameter("system", (Object)game.getSystem()).getResultList();
        entityManager.close();
        if (game.getSystem().getRid() != null && emulatorProfiles.isEmpty()) {
            try {
                Optional taskResult;
                f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/emulator/get_file.php");
                builder.a().a("v", 229).a("os", E.c().a()).a("arch", E.d().a()).a("system", game.getSystem().getRid());
                g post = new g().a("auth", ag.a().f());
                a request = new a(builder.b());
                d serverResponse = request.a(post);
                h context = new h(serverResponse.b());
                az emulatorFileDownloadConfirmationDialog = new az(context);
                Optional result = emulatorFileDownloadConfirmationDialog.showAndWait();
                if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.YES) {
                    i emulatorFileDownloadTask = new i(context);
                    Thread thread = new Thread((Runnable)((Object)emulatorFileDownloadTask));
                    an emulatorFileDownloadDialog = new an(emulatorFileDownloadTask);
                    thread.start();
                    taskResult = emulatorFileDownloadDialog.showAndWait();
                    if (!taskResult.isPresent()) {
                        return;
                    }
                } else {
                    return;
                }
                emulatorProfiles.addAll(((EmulatorFile)taskResult.get()).getEmulator().getFiles().stream().flatMap(emulatorFile -> emulatorFile.getProfiles().stream()).filter(emulatorProfile -> emulatorProfile.getSystems().contains(game.getSystem())).collect(Collectors.toList()));
            }
            catch (NetworkOfflineException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
            catch (Exception exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        switch (emulatorProfiles.size()) {
            case 0: {
                ApplicationAlert alert = new ApplicationAlert(this.resources.getString("emulator.missing.alert.header"), this.resources.getString("emulator.missing.alert.content"), Alert.AlertType.WARNING);
                alert.showAndWait();
                break;
            }
            case 1: {
                cW.a(new z((EmulatorProfile)emulatorProfiles.get(0), gameProfile, arguments));
                break;
            }
            default: {
                aA dialog = new aA(emulatorProfiles, gameProfile.getEmulatorProfile());
                dialog.showAndWait().ifPresent(emulatorProfile -> cW.a(new z((EmulatorProfile)emulatorProfile, gameProfile, arguments)));
            }
        }
    }

    @Subscribe
    private void a(cg event) {
        this.root.setVisible(event.a() == ApplicationView.LIBRARY);
    }

    @Subscribe
    private void a(cE event) {
        EntityManager entityManager = org.romstation.application.b.c();
        long count = (Long)entityManager.createNamedQuery("Game.countAll", Long.class).getSingleResult();
        entityManager.close();
        String message = MessageFormat.format(this.resources.getString("library.search.result"), event.a().size(), count);
        this.searchResultLabel.setText(message);
    }

    @Subscribe
    private void a(cx event) {
        this.a(event.a(), event.b());
    }

    @Subscribe
    private void a(cy event) {
        this.a(event.a(), event.b());
    }

    @Subscribe
    private void a(cz event) {
        this.a(event.a(), event.b());
    }

    @Subscribe
    private void a(bX event) {
        z context = event.a();
        if (context.getGameProfile() != null) {
            Game game = context.getGameProfile().getGameFile().getGame();
            game.setLastUse(Instant.now().getEpochSecond());
            GameProfile gameProfile = context.getGameProfile();
            gameProfile.setEmulatorProfile(context.getEmulatorProfile());
            EntityManager entityManager = org.romstation.application.b.c();
            entityManager.getTransaction().begin();
            entityManager.createQuery("update Game set lastUse = :timestamp where id = :id").setParameter("timestamp", (Object)game.getLastUse()).setParameter("id", (Object)game.getId()).executeUpdate();
            entityManager.createQuery("update GameProfile set emulatorProfile = :profile where id = :id").setParameter("profile", (Object)gameProfile.getEmulatorProfile()).setParameter("id", (Object)gameProfile.getId()).executeUpdate();
            entityManager.getTransaction().commit();
            entityManager.close();
        }
    }

    @Subscribe
    private void a(bY event) {
        z context = event.a();
        if (context.getGameProfile() != null) {
            Game game = context.getGameProfile().getGameFile().getGame();
            long played = Instant.now().getEpochSecond() - game.getLastUse();
            if (game.getPlayed() == null) {
                game.setPlayed(played);
            } else {
                game.setPlayed(game.getPlayed() + played);
            }
            EntityManager entityManager = org.romstation.application.b.c();
            entityManager.getTransaction().begin();
            entityManager.createQuery("update Game set played = :timestamp where id = :id").setParameter("timestamp", (Object)game.getPlayed()).setParameter("id", (Object)game.getId()).executeUpdate();
            entityManager.getTransaction().commit();
            entityManager.close();
            if (game.getRid() != null) {
                new Thread(() -> {
                    try {
                        f builder = new f(org.romstation.application.network.b.b() + "/romstation/scripts/game/set_played.php");
                        builder.a().a("v", 229).a("os", E.c().a()).a("gid", game.getRid()).a("efid", context.getEmulatorProfile().getEmulatorFile().getRid()).a("t", played);
                        g post = new g().a("auth", ag.a().f());
                        a request = new a(builder.b());
                        request.a(post);
                    }
                    catch (NetworkOfflineException exception) {
                        RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                    }
                    catch (MalformedURLException | InvalidServerResponseException | ServerResponseException exception) {
                        RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }).start();
            }
        }
    }

    @Subscribe
    private void a(cs event) {
        aZ dialog = new aZ(event.a());
        dialog.showAndWait().ifPresent(game -> {
            EntityManager entityManager = org.romstation.application.b.c();
            entityManager.getTransaction().begin();
            entityManager.merge(game);
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new cj());
        });
    }

    @Subscribe
    private void a(cr event) {
        ApplicationAlert alert = new ApplicationAlert(Alert.AlertType.CONFIRMATION);
        alert.setHeaderText(this.resources.getString("game.delete.alert.header"));
        alert.setContentText(this.resources.getString("game.delete.alert.content"));
        Optional alertResult = alert.showAndWait();
        if (alertResult.isPresent() && alertResult.get() == ButtonType.OK) {
            m gameDeleteTask = new m(event.a());
            Thread thread = new Thread((Runnable)((Object)gameDeleteTask));
            av<List<Game>> dialog = new av<List<Game>>(gameDeleteTask, "delete");
            thread.start();
            Optional dialogResult = dialog.showAndWait();
            dialogResult.ifPresent(items -> {
                if (!items.isEmpty()) {
                    RomStationController.a.post((Object)new cj());
                }
            });
        }
    }

    @Subscribe
    private void a(cA event) {
        Game game = event.a();
        if (game != null && game.getDirectory() != null) {
            try {
                Desktop.getDesktop().open(new File(game.getDirectory()));
            }
            catch (IOException exception) {
                RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    @Subscribe
    private void a(cB event) {
        Game game = event.a();
        if (game != null) {
            aE dialog = new aE(game.getLinks());
            Optional optional = dialog.showAndWait();
            optional.ifPresent(link -> {
                if (link.isExternal()) {
                    try {
                        Desktop.getDesktop().browse(new URI(link.getLocation()));
                    }
                    catch (Exception exception) {
                        RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                    }
                } else {
                    RomStationController.a.post((Object)new cR(link.getLocation(), true));
                    RomStationController.a.post((Object)new ch(ApplicationView.BROWSER));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    private void a(ce event) {
        Path root = Paths.get("", new String[0]).toAbsolutePath().getParent();
        if (Files.exists(root.resolve("database.sqlite"), new LinkOption[0]) && Files.notExists(root.resolve("imported"), new LinkOption[0]) && Files.notExists(root.resolve("games_imported"), new LinkOption[0])) {
            try {
                ad gameScannerTask = new ad(root);
                gameScannerTask.run();
                List games = (List)gameScannerTask.get();
                if (!games.isEmpty()) {
                    ac gameImporterTask = new ac(games);
                    Thread thread = new Thread((Runnable)((Object)gameImporterTask));
                    av<List<Game>> taskDialog = new av<List<Game>>(gameImporterTask);
                    thread.start();
                    taskDialog.showAndWait();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                try {
                    Files.createFile(root.resolve("games_imported"), new FileAttribute[0]);
                }
                catch (IOException exception) {
                    RomStation.b().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        this.filtersController.b();
        this.filtersController.a();
    }

    @Subscribe
    private void a(cf event) {
        if (this.viewToggleGroup.getSelectedToggle() == this.tableViewToggle) {
            RomStation.c().setProperty("library.view", LibraryView.TABLE_VIEW.name());
        } else {
            RomStation.c().setProperty("library.view", LibraryView.GRID_VIEW.name());
        }
    }

    @FXML
    private void create() {
        aZ gameEditorDialog = new aZ(new Game());
        gameEditorDialog.showAndWait().ifPresent(entity -> {
            EntityManager entityManager = org.romstation.application.b.c();
            entityManager.getTransaction().begin();
            entityManager.merge(entity);
            entityManager.getTransaction().commit();
            entityManager.close();
            RomStationController.a.post((Object)new cj());
        });
    }

    @FXML
    private void bulkImport() {
        aq dialog = new aq();
        dialog.showAndWait().ifPresent(result -> {
            l task = new l(result.a(), result.b());
            Thread thread = new Thread((Runnable)((Object)task));
            av<List<Game>> taskDialog = new av<List<Game>>(task);
            thread.start();
            Optional dialogResult = taskDialog.showAndWait();
            dialogResult.ifPresent(items -> {
                if (!items.isEmpty()) {
                    RomStationController.a.post((Object)new cj());
                }
            });
        });
    }

    @FXML
    private void download() {
        RomStationController.a.post((Object)new cR(org.romstation.application.network.b.b() + "/games", true));
        RomStationController.a.post((Object)new ch(ApplicationView.BROWSER));
    }

    @FXML
    private void upload() {
        cV.b();
    }

    @FXML
    private void importLegacy() {
        be romstationDirectoryChooserDialog = new be();
        romstationDirectoryChooserDialog.showAndWait().ifPresent(path -> {
            try {
                ad gameScannerTask = new ad((Path)path);
                gameScannerTask.run();
                List games = (List)gameScannerTask.get();
                bd gameImporterDialog = new bd(games);
                gameImporterDialog.showAndWait().ifPresent(items -> {
                    ac task = new ac((List<ab>)items);
                    Thread thread = new Thread((Runnable)((Object)task));
                    av<List<Game>> taskDialog = new av<List<Game>>(task);
                    thread.start();
                    Optional dialogResult = taskDialog.showAndWait();
                    dialogResult.ifPresent(importedGames -> {
                        if (!importedGames.isEmpty()) {
                            RomStationController.a.post((Object)new cj());
                        }
                    });
                });
            }
            catch (Exception exception) {
                RomStation.b().log(Level.SEVERE, exception.getMessage(), exception);
            }
        });
    }

    public Node b() {
        return this.root;
    }
}

