/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.library.filters;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.romstation.application.RomStation;
import org.romstation.application.b;
import org.romstation.application.cE;
import org.romstation.application.cf;
import org.romstation.application.cj;
import org.romstation.application.d;
import org.romstation.application.database.entity.Developer;
import org.romstation.application.database.entity.Game;
import org.romstation.application.database.entity.Genre;
import org.romstation.application.database.entity.Language;
import org.romstation.application.database.entity.Publisher;
import org.romstation.application.database.entity.Series;
import org.romstation.application.database.entity.System;
import org.romstation.application.database.entity.Tag;
import org.romstation.application.e;
import org.romstation.application.f;
import org.romstation.application.g;
import org.romstation.application.h;
import org.romstation.application.i;
import org.romstation.application.k;
import org.romstation.application.o;
import org.romstation.application.q;
import org.romstation.application.r;
import org.romstation.application.s;
import org.romstation.application.t;
import org.romstation.application.view.control.cell.query.NamedFilterListCell;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.library.filters.LibraryFilterPane;
import org.romstation.application.x;

public class LibraryFiltersController {
    private final x a;
    private final NamedFilterListCell.Factory b;
    @FXML
    private Accordion accordion;
    @FXML
    private ListView<d> systemsListView;
    @FXML
    private ListView<d> genresListView;
    @FXML
    private ListView<d> languagesListView;
    @FXML
    private ListView<d> developersListView;
    @FXML
    private ListView<d> publishersListView;
    @FXML
    private ListView<d> seriesListView;
    @FXML
    private ListView<d> tagsListView;
    @FXML
    private ListView<d> activeFiltersListView;
    @FXML
    private Button resetFiltersButton;
    @FXML
    private Button deleteFiltersButton;

    public LibraryFiltersController() {
        RomStationController.a.register((Object)this);
        this.a = new x(null, new h(new k("root", "title"), i.UPPER), q.MATCH, new g<String>(String.class));
        this.b = new NamedFilterListCell.Factory(Game.class);
    }

    @FXML
    private void initialize() {
        this.systemsListView.setCellFactory((Callback)this.b);
        this.genresListView.setCellFactory((Callback)this.b);
        this.languagesListView.setCellFactory((Callback)this.b);
        this.developersListView.setCellFactory((Callback)this.b);
        this.publishersListView.setCellFactory((Callback)this.b);
        this.seriesListView.setCellFactory((Callback)this.b);
        this.tagsListView.setCellFactory((Callback)this.b);
        this.activeFiltersListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.activeFiltersListView.setItems(this.b.b());
        this.activeFiltersListView.getItems().addListener(c2 -> {
            if (this.accordion.getExpandedPane() != null) {
                ((ListView)this.accordion.getExpandedPane().getContent()).refresh();
            }
            this.a();
        });
        this.resetFiltersButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.activeFiltersListView.getItems()).isEqualTo(0));
        this.deleteFiltersButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.activeFiltersListView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.accordion.getPanes().stream().filter(pane -> {
            try {
                return pane.getUserData() == LibraryFilterPane.valueOf(RomStation.c().getProperty("library.filters.expandedPane"));
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }).findFirst().ifPresent(pane -> this.accordion.setExpandedPane(pane));
    }

    private Optional<r> a(List<d> namedFilters) {
        List items = namedFilters.stream().filter(arg_0 -> this.activeFiltersListView.getItems().contains(arg_0)).map(d::g).collect(Collectors.toList());
        if (items.isEmpty()) {
            return Optional.empty();
        }
        r groupFilter = new r(s.OR);
        groupFilter.c().setAll(items);
        return Optional.of(groupFilter);
    }

    public void a() {
        r root = new r(s.AND);
        root.c().add((Object)this.a);
        this.a((List<d>)this.systemsListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.genresListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.languagesListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.developersListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.publishersListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.seriesListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        this.a((List<d>)this.tagsListView.getItems()).ifPresent(groupFilter -> root.c().add(groupFilter));
        EntityManager entityManager = org.romstation.application.b.c();
        e<Game> queryBuilder = new e<Game>(Game.class);
        queryBuilder.a(root);
        f<Game> context = new f<Game>(queryBuilder, entityManager, Game.class);
        h queryExpression = new h(new k("root"), i.GET);
        TypedQuery<Game> typedQuery = queryBuilder.a(queryExpression, context, true);
        ObservableList games = FXCollections.observableList((List)typedQuery.getResultList());
        entityManager.close();
        RomStationController.a.post((Object)new cE((List<Game>)games));
    }

    public void a(String title) {
        this.a.c().a(title);
        this.a();
    }

    @FXML
    private void resetFilters(ActionEvent actionEvent) {
        this.activeFiltersListView.getItems().clear();
    }

    @FXML
    private void deleteFilters(ActionEvent actionEvent) {
        ObservableList selectedItems = this.activeFiltersListView.getSelectionModel().getSelectedItems();
        this.activeFiltersListView.getItems().removeAll(new ArrayList(selectedItems));
    }

    @Subscribe
    private void a(cj event) {
        this.b.a();
        this.b();
        this.a();
    }

    @Subscribe
    private void a(cf event) {
        if (this.accordion.getExpandedPane() != null) {
            RomStation.c().setProperty("library.filters.expandedPane", ((LibraryFilterPane)((Object)this.accordion.getExpandedPane().getUserData())).name());
        } else {
            RomStation.c().remove("library.filters.expandedPane");
        }
    }

    public void b() {
        this.systemsListView.getItems().setAll(this.c());
        this.genresListView.getItems().setAll(this.d());
        this.languagesListView.getItems().setAll(this.e());
        this.developersListView.getItems().setAll(this.f());
        this.publishersListView.getItems().setAll(this.g());
        this.seriesListView.getItems().setAll(this.h());
        this.tagsListView.getItems().setAll(this.i());
    }

    private List<d> c() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct game.system from Game game order by upper(game.system.name) asc", System.class).getResultList();
        entityManager.close();
        return entities.stream().map(system -> {
            o<System> filter = new o<System>(null, new h(new k("root", "system"), i.GET), q.EQUAL, new g<System>((System)system, System.class));
            return new d(System.class + ":" + system.getId(), system.getName(), system.getGraphic(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> d() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct genre from Game game join game.genres genre join genre.name.translations translation where translation.locale.tag = :tag", Genre.class).setParameter("tag", (Object)Locale.getDefault().toLanguageTag()).getResultStream().sorted((o1, o2) -> o1.getName().getDefaultString().compareToIgnoreCase(o2.getName().getDefaultString())).collect(Collectors.toList());
        entityManager.close();
        return entities.stream().map(genre -> {
            t<Genre> filter = new t<Genre>(genre.getName().getDefaultString(), new h(new k("root", "genres"), i.GET), q.IS_MEMBER, new g<Genre>((Genre)genre, Genre.class));
            return new d(Genre.class + ":" + genre.getId(), genre.getName().getDefaultString(), genre.getGraphic(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> e() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct language from Game game join game.languages language join language.name.translations translation where translation.locale.tag = :tag", Language.class).setParameter("tag", (Object)Locale.getDefault().toLanguageTag()).getResultStream().sorted((o1, o2) -> o1.getName().getDefaultString().compareToIgnoreCase(o2.getName().getDefaultString())).collect(Collectors.toList());
        entityManager.close();
        return entities.stream().map(language -> {
            t<Language> filter = new t<Language>(language.getName().getDefaultString(), new h(new k("root", "languages"), i.GET), q.IS_MEMBER, new g<Language>((Language)language, Language.class));
            return new d(Language.class + ":" + language.getId(), language.getName().getDefaultString(), language.getGraphic(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> f() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct game.developer from Game game order by upper(game.developer.name) asc", Developer.class).getResultList();
        entityManager.close();
        return entities.stream().map(developer -> {
            o<Developer> filter = new o<Developer>(developer.getName(), new h(new k("root", "developer"), i.GET), q.EQUAL, new g<Developer>((Developer)developer, Developer.class));
            return new d(Developer.class + ":" + developer.getId(), developer.getName(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> g() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct game.publisher from Game game order by upper(game.publisher.name) asc", Publisher.class).getResultList();
        entityManager.close();
        return entities.stream().map(publisher -> {
            o<Publisher> filter = new o<Publisher>(publisher.getName(), new h(new k("root", "publisher"), i.GET), q.EQUAL, new g<Publisher>((Publisher)publisher, Publisher.class));
            return new d(Publisher.class + ":" + publisher.getId(), publisher.getName(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> h() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct series from Game game join game.series series order by upper(series.name) asc", Series.class).getResultList();
        entityManager.close();
        return entities.stream().map(series -> {
            t<Series> filter = new t<Series>(series.getName(), new h(new k("root", "series"), i.GET), q.IS_MEMBER, new g<Series>((Series)series, Series.class));
            return new d(Series.class + ":" + series.getId(), series.getName(), filter);
        }).collect(Collectors.toList());
    }

    private List<d> i() {
        EntityManager entityManager = org.romstation.application.b.c();
        List entities = entityManager.createQuery("select distinct tag from Game game join game.tags tag join tag.name.translations translation where translation.locale.tag = :tag", Tag.class).setParameter("tag", (Object)Locale.getDefault().toLanguageTag()).getResultStream().sorted((o1, o2) -> o1.getName().getDefaultString().compareToIgnoreCase(o2.getName().getDefaultString())).collect(Collectors.toList());
        entityManager.close();
        return entities.stream().map(tag -> {
            t<Tag> filter = new t<Tag>(tag.getName().getDefaultString(), new h(new k("root", "tags"), i.GET), q.IS_MEMBER, new g<Tag>((Tag)tag, Tag.class));
            return new d(Tag.class + ":" + tag.getId(), tag.getName().getDefaultString(), tag.getGraphic(), filter);
        }).collect(Collectors.toList());
    }
}

