/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.view.controller.library.table;

import com.google.common.eventbus.Subscribe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.romstation.application.RomStation;
import org.romstation.application.cA;
import org.romstation.application.cB;
import org.romstation.application.cE;
import org.romstation.application.cf;
import org.romstation.application.cr;
import org.romstation.application.cs;
import org.romstation.application.cx;
import org.romstation.application.database.entity.Game;
import org.romstation.application.view.controller.RomStationController;
import org.romstation.application.view.controller.library.LibraryController;
import org.romstation.application.view.controller.library.table.LibraryTableViewColumn;
import org.romstation.application.view.controller.library.table.LibraryTableViewGameTableRow;

public class LibraryTableViewController {
    @FXML
    private TableView<Game> tableView;
    @FXML
    private TableColumn<Game, Integer> filesTableColumn;
    @FXML
    private Button launchButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button editButton;
    @FXML
    private Button openExplorerButton;
    @FXML
    private Button showLinksButton;

    @FXML
    private void initialize() {
        RomStationController.a.register((Object)this);
        JsonParser jsonParser = new JsonParser();
        JsonArray jsonArray = (JsonArray)jsonParser.parse(RomStation.c().getProperty("library.tableView.sort"));
        jsonArray.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            this.tableView.getColumns().stream().filter(column -> {
                try {
                    return column.getUserData() == LibraryTableViewColumn.valueOf(object.get("column").getAsString());
                }
                catch (IllegalArgumentException ex) {
                    return false;
                }
            }).findFirst().ifPresent(column -> {
                column.setSortType(TableColumn.SortType.valueOf((String)object.get("order").getAsString()));
                this.tableView.getSortOrder().add(column);
            });
        });
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setRowFactory((Callback)new LibraryTableViewGameTableRow.Factory(LibraryController.a()));
        this.filesTableColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((Game)param.getValue()).getFiles().size()));
        this.launchButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.deleteButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isEqualTo(0));
        this.editButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.openExplorerButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
        this.showLinksButton.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1));
    }

    @FXML
    private void launch() {
        RomStationController.a.post((Object)new cx((Game)this.tableView.getSelectionModel().getSelectedItem(), new String[0]));
    }

    @FXML
    private void edit() {
        RomStationController.a.post((Object)new cs((Game)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void delete() {
        RomStationController.a.post((Object)new cr((List<Game>)this.tableView.getSelectionModel().getSelectedItems()));
    }

    @FXML
    private void openExplorer() {
        RomStationController.a.post((Object)new cA((Game)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void showLinks() {
        RomStationController.a.post((Object)new cB((Game)this.tableView.getSelectionModel().getSelectedItem()));
    }

    @Subscribe
    private void a(cE event) {
        this.tableView.getItems().setAll(event.a());
        this.tableView.sort();
    }

    @Subscribe
    private void a(cf event) {
        JsonArray jsonArray = new JsonArray();
        for (TableColumn column : this.tableView.getSortOrder()) {
            JsonObject element = new JsonObject();
            element.addProperty("column", ((LibraryTableViewColumn)((Object)column.getUserData())).name());
            element.addProperty("order", column.getSortType().name());
            jsonArray.add((JsonElement)element);
        }
        RomStation.c().setProperty("library.tableView.sort", jsonArray.toString());
    }

    @FXML
    private void keyPressed(KeyEvent keyEvent) {
        if (!this.tableView.getSelectionModel().isEmpty()) {
            switch (keyEvent.getCode()) {
                case ENTER: {
                    RomStationController.a.post((Object)new cx((Game)this.tableView.getSelectionModel().getSelectedItem(), new String[0]));
                    break;
                }
                case DELETE: {
                    RomStationController.a.post((Object)new cr((List<Game>)this.tableView.getSelectionModel().getSelectedItems()));
                }
            }
        }
    }
}

