/*
 * Decompiled with CFR 0.152.
 */
package org.romstation.application.virtualcontroller.device;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.DirectAndRawInputEnvironmentPlugin;
import net.java.games.input.OSXEnvironmentPlugin;
import org.romstation.application.E;
import org.romstation.application.virtualcontroller.device.DeviceNotFoundException;
import org.romstation.application.virtualcontroller.device.IdentifierNotFoundException;
import org.romstation.application.virtualcontroller.device.a;

public class b
extends a {
    private static final HashMap<String, Component.Identifier> a = new HashMap();
    private final int b;
    private final Controller c;
    private final String d;

    public b(Controller controller) {
        this(0, controller);
    }

    public b(int index, Controller controller) {
        this.b = index;
        this.c = controller;
        CRC32 crc32 = new CRC32();
        for (Component component : controller.getComponents()) {
            crc32.update(component.getIdentifier().getName().getBytes());
        }
        this.d = String.format("%08x", crc32.getValue());
    }

    public int e() {
        return this.b;
    }

    public Controller f() {
        return this.c;
    }

    public String g() {
        return this.d;
    }

    @Override
    public String a() {
        return this.c.getName();
    }

    @Override
    public List<String> b() {
        LinkedList<String> commands = new LinkedList<String>(a.keySet());
        commands.sort(String::compareTo);
        return commands;
    }

    @Override
    public boolean c() {
        return this.c.poll();
    }

    @Override
    public void d() {
    }

    @Override
    protected float a(String command) {
        block18: {
            try {
                Component component = this.c.getComponent(org.romstation.application.virtualcontroller.device.b.c(command));
                if (component == null) break block18;
                float data = component.getPollData();
                if (component.getIdentifier() instanceof Component.Identifier.Button) {
                    return data;
                }
                if (!(component.getIdentifier() instanceof Component.Identifier.Axis)) break block18;
                if (component.getIdentifier() == Component.Identifier.Axis.POV) {
                    switch (command) {
                        case "POV.UP": {
                            return data == 0.125f || data == 0.25f || data == 0.375f ? 1.0f : 0.0f;
                        }
                        case "POV.RIGHT": {
                            return data == 0.375f || data == 0.5f || data == 0.625f ? 1.0f : 0.0f;
                        }
                        case "POV.DOWN": {
                            return data == 0.625f || data == 0.75f || data == 0.875f ? 1.0f : 0.0f;
                        }
                        case "POV.LEFT": {
                            return data == 0.875f || data == 1.0f || data == 0.125f ? 1.0f : 0.0f;
                        }
                    }
                    break block18;
                }
                if (command.endsWith("-")) {
                    return data < 0.0f ? -data : 0.0f;
                }
                if (command.endsWith("+")) {
                    return data > 0.0f ? data : 0.0f;
                }
                return (1.0f + data) / 2.0f;
            }
            catch (IdentifierNotFoundException exception) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        b device = (b)object;
        return this.c.getName().equals(device.c.getName()) && this.b == device.e();
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    private static Controller[] j() {
        switch (E.c()) {
            case WINDOWS: {
                return new DirectAndRawInputEnvironmentPlugin().getControllers();
            }
            case MAC_OS: {
                return new OSXEnvironmentPlugin().getControllers();
            }
        }
        return new Controller[0];
    }

    public static List<b> h() {
        LinkedList<b> devices = new LinkedList<b>();
        for (Controller controller : org.romstation.application.virtualcontroller.device.b.j()) {
            if (controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.STICK && controller.getType() != Controller.Type.FINGERSTICK && controller.getType() != Controller.Type.WHEEL) continue;
            long index = devices.stream().filter(device -> device.a().equals(controller.getName())).count();
            devices.add(new b((int)index, controller));
        }
        return devices;
    }

    public static List<b> i() {
        LinkedList<b> devices = new LinkedList<b>();
        for (Controller controller : org.romstation.application.virtualcontroller.device.b.j()) {
            if (controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.STICK && controller.getType() != Controller.Type.FINGERSTICK && controller.getType() != Controller.Type.WHEEL && controller.getType() != Controller.Type.UNKNOWN) continue;
            long index = devices.stream().filter(device -> device.a().equals(controller.getName())).count();
            devices.add(new b((int)index, controller));
        }
        return devices;
    }

    public static b b(String name) throws DeviceNotFoundException {
        return org.romstation.application.virtualcontroller.device.b.a(0, name);
    }

    public static b a(int index, String name) throws DeviceNotFoundException {
        int deviceIndex = 0;
        for (Controller controller : org.romstation.application.virtualcontroller.device.b.j()) {
            if (!controller.getName().equals(name)) continue;
            if (deviceIndex == index) {
                return new b(0, controller);
            }
            ++deviceIndex;
        }
        throw new DeviceNotFoundException(String.format("device %s not found", name));
    }

    private static Component.Identifier c(String command) throws IdentifierNotFoundException {
        if (a.containsKey(command)) {
            return a.get(command);
        }
        throw new IdentifierNotFoundException(String.format("unable to map command %s to identifier", command));
    }

    public static String a(Component.Identifier identifier) throws IdentifierNotFoundException {
        return org.romstation.application.virtualcontroller.device.b.a(identifier, 0.0f);
    }

    public static String a(Component.Identifier identifier, float value) throws IdentifierNotFoundException {
        for (Map.Entry<String, Component.Identifier> entry : a.entrySet()) {
            if (entry.getValue() != identifier) continue;
            if (identifier instanceof Component.Identifier.Button) {
                return entry.getKey();
            }
            if (!(identifier instanceof Component.Identifier.Axis)) break;
            if (identifier == Component.Identifier.Axis.POV) {
                switch ((int)(value * 8.0f)) {
                    case 2: {
                        return "POV.UP";
                    }
                    case 4: {
                        return "POV.RIGHT";
                    }
                    case 6: {
                        return "POV.DOWN";
                    }
                    case 8: {
                        return "POV.LEFT";
                    }
                }
                break;
            }
            String code = entry.getKey().replaceFirst("[+-]$", "");
            if (value > 0.0f) {
                return String.format("%s+", code);
            }
            if (value < 0.0f) {
                return String.format("%s-", code);
            }
            return code;
        }
        throw new IdentifierNotFoundException(String.format("unable to map identifier %s to command", identifier.getName()));
    }

    static {
        a.put("BUTTON.0", (Component.Identifier)Component.Identifier.Button._0);
        a.put("BUTTON.1", (Component.Identifier)Component.Identifier.Button._1);
        a.put("BUTTON.10", (Component.Identifier)Component.Identifier.Button._10);
        a.put("BUTTON.11", (Component.Identifier)Component.Identifier.Button._11);
        a.put("BUTTON.12", (Component.Identifier)Component.Identifier.Button._12);
        a.put("BUTTON.13", (Component.Identifier)Component.Identifier.Button._13);
        a.put("BUTTON.14", (Component.Identifier)Component.Identifier.Button._14);
        a.put("BUTTON.15", (Component.Identifier)Component.Identifier.Button._15);
        a.put("BUTTON.16", (Component.Identifier)Component.Identifier.Button._16);
        a.put("BUTTON.17", (Component.Identifier)Component.Identifier.Button._17);
        a.put("BUTTON.18", (Component.Identifier)Component.Identifier.Button._18);
        a.put("BUTTON.19", (Component.Identifier)Component.Identifier.Button._19);
        a.put("BUTTON.2", (Component.Identifier)Component.Identifier.Button._2);
        a.put("BUTTON.20", (Component.Identifier)Component.Identifier.Button._20);
        a.put("BUTTON.21", (Component.Identifier)Component.Identifier.Button._21);
        a.put("BUTTON.22", (Component.Identifier)Component.Identifier.Button._22);
        a.put("BUTTON.23", (Component.Identifier)Component.Identifier.Button._23);
        a.put("BUTTON.24", (Component.Identifier)Component.Identifier.Button._24);
        a.put("BUTTON.25", (Component.Identifier)Component.Identifier.Button._25);
        a.put("BUTTON.26", (Component.Identifier)Component.Identifier.Button._26);
        a.put("BUTTON.27", (Component.Identifier)Component.Identifier.Button._27);
        a.put("BUTTON.28", (Component.Identifier)Component.Identifier.Button._28);
        a.put("BUTTON.29", (Component.Identifier)Component.Identifier.Button._29);
        a.put("BUTTON.3", (Component.Identifier)Component.Identifier.Button._3);
        a.put("BUTTON.30", (Component.Identifier)Component.Identifier.Button._30);
        a.put("BUTTON.31", (Component.Identifier)Component.Identifier.Button._31);
        a.put("BUTTON.4", (Component.Identifier)Component.Identifier.Button._4);
        a.put("BUTTON.5", (Component.Identifier)Component.Identifier.Button._5);
        a.put("BUTTON.6", (Component.Identifier)Component.Identifier.Button._6);
        a.put("BUTTON.7", (Component.Identifier)Component.Identifier.Button._7);
        a.put("BUTTON.8", (Component.Identifier)Component.Identifier.Button._8);
        a.put("BUTTON.9", (Component.Identifier)Component.Identifier.Button._9);
        a.put("BUTTON.A", (Component.Identifier)Component.Identifier.Button.A);
        a.put("BUTTON.B", (Component.Identifier)Component.Identifier.Button.B);
        a.put("BUTTON.BACK", (Component.Identifier)Component.Identifier.Button.BACK);
        a.put("BUTTON.BASE", (Component.Identifier)Component.Identifier.Button.BASE);
        a.put("BUTTON.BASE2", (Component.Identifier)Component.Identifier.Button.BASE2);
        a.put("BUTTON.BASE3", (Component.Identifier)Component.Identifier.Button.BASE3);
        a.put("BUTTON.BASE4", (Component.Identifier)Component.Identifier.Button.BASE4);
        a.put("BUTTON.BASE5", (Component.Identifier)Component.Identifier.Button.BASE5);
        a.put("BUTTON.BASE6", (Component.Identifier)Component.Identifier.Button.BASE6);
        a.put("BUTTON.C", (Component.Identifier)Component.Identifier.Button.C);
        a.put("BUTTON.DEAD", (Component.Identifier)Component.Identifier.Button.DEAD);
        a.put("BUTTON.EXTRA", (Component.Identifier)Component.Identifier.Button.EXTRA);
        a.put("BUTTON.EXTRA_1", (Component.Identifier)Component.Identifier.Button.EXTRA_1);
        a.put("BUTTON.EXTRA_10", (Component.Identifier)Component.Identifier.Button.EXTRA_10);
        a.put("BUTTON.EXTRA_11", (Component.Identifier)Component.Identifier.Button.EXTRA_11);
        a.put("BUTTON.EXTRA_12", (Component.Identifier)Component.Identifier.Button.EXTRA_12);
        a.put("BUTTON.EXTRA_13", (Component.Identifier)Component.Identifier.Button.EXTRA_13);
        a.put("BUTTON.EXTRA_14", (Component.Identifier)Component.Identifier.Button.EXTRA_14);
        a.put("BUTTON.EXTRA_15", (Component.Identifier)Component.Identifier.Button.EXTRA_15);
        a.put("BUTTON.EXTRA_16", (Component.Identifier)Component.Identifier.Button.EXTRA_16);
        a.put("BUTTON.EXTRA_17", (Component.Identifier)Component.Identifier.Button.EXTRA_17);
        a.put("BUTTON.EXTRA_18", (Component.Identifier)Component.Identifier.Button.EXTRA_18);
        a.put("BUTTON.EXTRA_19", (Component.Identifier)Component.Identifier.Button.EXTRA_19);
        a.put("BUTTON.EXTRA_2", (Component.Identifier)Component.Identifier.Button.EXTRA_2);
        a.put("BUTTON.EXTRA_20", (Component.Identifier)Component.Identifier.Button.EXTRA_20);
        a.put("BUTTON.EXTRA_21", (Component.Identifier)Component.Identifier.Button.EXTRA_21);
        a.put("BUTTON.EXTRA_22", (Component.Identifier)Component.Identifier.Button.EXTRA_22);
        a.put("BUTTON.EXTRA_23", (Component.Identifier)Component.Identifier.Button.EXTRA_23);
        a.put("BUTTON.EXTRA_24", (Component.Identifier)Component.Identifier.Button.EXTRA_24);
        a.put("BUTTON.EXTRA_25", (Component.Identifier)Component.Identifier.Button.EXTRA_25);
        a.put("BUTTON.EXTRA_26", (Component.Identifier)Component.Identifier.Button.EXTRA_26);
        a.put("BUTTON.EXTRA_27", (Component.Identifier)Component.Identifier.Button.EXTRA_27);
        a.put("BUTTON.EXTRA_28", (Component.Identifier)Component.Identifier.Button.EXTRA_28);
        a.put("BUTTON.EXTRA_29", (Component.Identifier)Component.Identifier.Button.EXTRA_29);
        a.put("BUTTON.EXTRA_3", (Component.Identifier)Component.Identifier.Button.EXTRA_3);
        a.put("BUTTON.EXTRA_30", (Component.Identifier)Component.Identifier.Button.EXTRA_30);
        a.put("BUTTON.EXTRA_31", (Component.Identifier)Component.Identifier.Button.EXTRA_31);
        a.put("BUTTON.EXTRA_32", (Component.Identifier)Component.Identifier.Button.EXTRA_32);
        a.put("BUTTON.EXTRA_33", (Component.Identifier)Component.Identifier.Button.EXTRA_33);
        a.put("BUTTON.EXTRA_34", (Component.Identifier)Component.Identifier.Button.EXTRA_34);
        a.put("BUTTON.EXTRA_35", (Component.Identifier)Component.Identifier.Button.EXTRA_35);
        a.put("BUTTON.EXTRA_36", (Component.Identifier)Component.Identifier.Button.EXTRA_36);
        a.put("BUTTON.EXTRA_37", (Component.Identifier)Component.Identifier.Button.EXTRA_37);
        a.put("BUTTON.EXTRA_38", (Component.Identifier)Component.Identifier.Button.EXTRA_38);
        a.put("BUTTON.EXTRA_39", (Component.Identifier)Component.Identifier.Button.EXTRA_39);
        a.put("BUTTON.EXTRA_4", (Component.Identifier)Component.Identifier.Button.EXTRA_4);
        a.put("BUTTON.EXTRA_40", (Component.Identifier)Component.Identifier.Button.EXTRA_40);
        a.put("BUTTON.EXTRA_5", (Component.Identifier)Component.Identifier.Button.EXTRA_5);
        a.put("BUTTON.EXTRA_6", (Component.Identifier)Component.Identifier.Button.EXTRA_6);
        a.put("BUTTON.EXTRA_7", (Component.Identifier)Component.Identifier.Button.EXTRA_7);
        a.put("BUTTON.EXTRA_8", (Component.Identifier)Component.Identifier.Button.EXTRA_8);
        a.put("BUTTON.EXTRA_9", (Component.Identifier)Component.Identifier.Button.EXTRA_9);
        a.put("BUTTON.FORWARD", (Component.Identifier)Component.Identifier.Button.FORWARD);
        a.put("BUTTON.LEFT", (Component.Identifier)Component.Identifier.Button.LEFT);
        a.put("BUTTON.LEFT_THUMB", (Component.Identifier)Component.Identifier.Button.LEFT_THUMB);
        a.put("BUTTON.LEFT_THUMB2", (Component.Identifier)Component.Identifier.Button.LEFT_THUMB2);
        a.put("BUTTON.LEFT_THUMB3", (Component.Identifier)Component.Identifier.Button.LEFT_THUMB3);
        a.put("BUTTON.MIDDLE", (Component.Identifier)Component.Identifier.Button.MIDDLE);
        a.put("BUTTON.MODE", (Component.Identifier)Component.Identifier.Button.MODE);
        a.put("BUTTON.PINKIE", (Component.Identifier)Component.Identifier.Button.PINKIE);
        a.put("BUTTON.RIGHT", (Component.Identifier)Component.Identifier.Button.RIGHT);
        a.put("BUTTON.RIGHT_THUMB", (Component.Identifier)Component.Identifier.Button.RIGHT_THUMB);
        a.put("BUTTON.RIGHT_THUMB2", (Component.Identifier)Component.Identifier.Button.RIGHT_THUMB2);
        a.put("BUTTON.RIGHT_THUMB3", (Component.Identifier)Component.Identifier.Button.RIGHT_THUMB3);
        a.put("BUTTON.SELECT", (Component.Identifier)Component.Identifier.Button.SELECT);
        a.put("BUTTON.SIDE", (Component.Identifier)Component.Identifier.Button.SIDE);
        a.put("BUTTON.START", (Component.Identifier)Component.Identifier.Button.START);
        a.put("BUTTON.STYLUS", (Component.Identifier)Component.Identifier.Button.STYLUS);
        a.put("BUTTON.STYLUS2", (Component.Identifier)Component.Identifier.Button.STYLUS2);
        a.put("BUTTON.THUMB", (Component.Identifier)Component.Identifier.Button.THUMB);
        a.put("BUTTON.THUMB2", (Component.Identifier)Component.Identifier.Button.THUMB2);
        a.put("BUTTON.TOOL_AIRBRUSH", (Component.Identifier)Component.Identifier.Button.TOOL_AIRBRUSH);
        a.put("BUTTON.TOOL_BRUSH", (Component.Identifier)Component.Identifier.Button.TOOL_BRUSH);
        a.put("BUTTON.TOOL_FINGER", (Component.Identifier)Component.Identifier.Button.TOOL_FINGER);
        a.put("BUTTON.TOOL_LENS", (Component.Identifier)Component.Identifier.Button.TOOL_LENS);
        a.put("BUTTON.TOOL_MOUSE", (Component.Identifier)Component.Identifier.Button.TOOL_MOUSE);
        a.put("BUTTON.TOOL_PEN", (Component.Identifier)Component.Identifier.Button.TOOL_PEN);
        a.put("BUTTON.TOOL_PENCIL", (Component.Identifier)Component.Identifier.Button.TOOL_PENCIL);
        a.put("BUTTON.TOOL_RUBBER", (Component.Identifier)Component.Identifier.Button.TOOL_RUBBER);
        a.put("BUTTON.TOP", (Component.Identifier)Component.Identifier.Button.TOP);
        a.put("BUTTON.TOP2", (Component.Identifier)Component.Identifier.Button.TOP2);
        a.put("BUTTON.TOUCH", (Component.Identifier)Component.Identifier.Button.TOUCH);
        a.put("BUTTON.TRIGGER", (Component.Identifier)Component.Identifier.Button.TRIGGER);
        a.put("BUTTON.UNKNOWN", (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        a.put("BUTTON.X", (Component.Identifier)Component.Identifier.Button.X);
        a.put("BUTTON.Y", (Component.Identifier)Component.Identifier.Button.Y);
        a.put("BUTTON.Z", (Component.Identifier)Component.Identifier.Button.Z);
        a.put("AXIS.X", (Component.Identifier)Component.Identifier.Axis.X);
        a.put("AXIS.X-", (Component.Identifier)Component.Identifier.Axis.X);
        a.put("AXIS.X+", (Component.Identifier)Component.Identifier.Axis.X);
        a.put("AXIS.Y", (Component.Identifier)Component.Identifier.Axis.Y);
        a.put("AXIS.Y-", (Component.Identifier)Component.Identifier.Axis.Y);
        a.put("AXIS.Y+", (Component.Identifier)Component.Identifier.Axis.Y);
        a.put("AXIS.Z", (Component.Identifier)Component.Identifier.Axis.Z);
        a.put("AXIS.Z-", (Component.Identifier)Component.Identifier.Axis.Z);
        a.put("AXIS.Z+", (Component.Identifier)Component.Identifier.Axis.Z);
        a.put("AXIS.RX", (Component.Identifier)Component.Identifier.Axis.RX);
        a.put("AXIS.RX-", (Component.Identifier)Component.Identifier.Axis.RX);
        a.put("AXIS.RX+", (Component.Identifier)Component.Identifier.Axis.RX);
        a.put("AXIS.RY", (Component.Identifier)Component.Identifier.Axis.RY);
        a.put("AXIS.RY-", (Component.Identifier)Component.Identifier.Axis.RY);
        a.put("AXIS.RY+", (Component.Identifier)Component.Identifier.Axis.RY);
        a.put("AXIS.RZ", (Component.Identifier)Component.Identifier.Axis.RZ);
        a.put("AXIS.RZ-", (Component.Identifier)Component.Identifier.Axis.RZ);
        a.put("AXIS.RZ+", (Component.Identifier)Component.Identifier.Axis.RZ);
        a.put("AXIS.SLIDER", (Component.Identifier)Component.Identifier.Axis.SLIDER);
        a.put("AXIS.SLIDER-", (Component.Identifier)Component.Identifier.Axis.SLIDER);
        a.put("AXIS.SLIDER+", (Component.Identifier)Component.Identifier.Axis.SLIDER);
        a.put("POV.UP", (Component.Identifier)Component.Identifier.Axis.POV);
        a.put("POV.RIGHT", (Component.Identifier)Component.Identifier.Axis.POV);
        a.put("POV.DOWN", (Component.Identifier)Component.Identifier.Axis.POV);
        a.put("POV.LEFT", (Component.Identifier)Component.Identifier.Axis.POV);
    }
}

