/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.rpc.ProcessId;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RenderProcess
extends CloseableImpl
implements com.teamdev.jxbrowser.frame.RenderProcess {
    private static final IdMap<RenderProcessId, RenderProcess> processes = new IdMap();
    private final RenderProcessId id;
    private final Connection connection;
    private final List<FrameImpl> frames;
    private final ProcessId pid;

    public static Optional<RenderProcess> with(RenderProcessId id) {
        Preconditions.checkNotNull(id);
        Logger.debug("Finding render process with id: {0}", id);
        return processes.find(id);
    }

    RenderProcess(Connection connection, RenderProcessId id, ProcessId pid) {
        Preconditions.checkNotNull(id);
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(pid);
        this.pid = pid;
        this.id = id;
        this.connection = connection;
        this.frames = new CopyOnWriteArrayList<FrameImpl>();
    }

    public RenderProcessId id() {
        return this.id;
    }

    public Connection connection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.frames.forEach(frame -> {
            frame.close();
            frame.unregister();
        });
        super.close();
    }

    public void addFrame(FrameImpl frame) {
        Logger.debug("Adding frame: {0}", frame.id());
        this.frames.add(frame);
    }

    public void removeFrame(FrameImpl frame) {
        Logger.debug("Removing frame: {0}", frame.id());
        this.frames.remove(frame);
    }

    @Override
    public int pid() {
        return this.pid.getValue();
    }
}

