/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.collect;

import com.teamdev.jxbrowser.deps.com.google.common.collect.Iterators;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Lists;
import com.teamdev.jxbrowser.deps.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;

public final class Iterables {
    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    static <T> T[] toArray(Iterable<? extends T> iterable, T[] array) {
        Collection<T> collection = Iterables.castOrCopyToCollection(iterable);
        return collection.toArray(array);
    }

    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : Lists.newArrayList(iterable.iterator());
    }

    public static <T> @Nullable T getFirst(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        return Iterators.getNext(iterable.iterator(), defaultValue);
    }
}

