/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.deps.com.google.common.collect;

import com.teamdev.jxbrowser.deps.com.google.common.base.Function;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.AbstractMapEntry;
import com.teamdev.jxbrowser.deps.com.google.common.collect.CollectPreconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Collections2;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableEntry;
import com.teamdev.jxbrowser.deps.com.google.common.collect.Iterators;
import com.teamdev.jxbrowser.deps.com.google.common.collect.TransformedIterator;
import com.teamdev.jxbrowser.deps.com.google.common.collect.UnmodifiableIterator;
import com.teamdev.jxbrowser.deps.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Maps {
    static <V> Function<Map.Entry<?, V>, V> valueFunction() {
        return EntryFunction.VALUE;
    }

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return new TransformedIterator<Map.Entry<K, V>, K>(entryIterator){

            @Override
            K transform(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return new TransformedIterator<Map.Entry<K, V>, V>(entryIterator){

            @Override
            V transform(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    static <K, V> Map.Entry<K, V> unmodifiableEntry(final Map.Entry<? extends K, ? extends V> entry) {
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }
        };
    }

    static <K, V> UnmodifiableIterator<Map.Entry<K, V>> unmodifiableEntryIterator(final Iterator<Map.Entry<K, V>> entryIterator) {
        return new UnmodifiableIterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return Maps.unmodifiableEntry((Map.Entry)entryIterator.next());
            }
        };
    }

    static boolean containsKeyImpl(Map<?, ?> map, @Nullable Object key) {
        return Iterators.contains(Maps.keyIterator(map.entrySet().iterator()), key);
    }

    static boolean containsValueImpl(Map<?, ?> map, @Nullable Object value) {
        return Iterators.contains(Maps.valueIterator(map.entrySet().iterator()), value);
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map o = (Map)object;
            return map.entrySet().equals(o.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.append('}').toString();
    }

    static <K, V> void putAllImpl(Map<K, V> self, Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            self.put(entry.getKey(), entry.getValue());
        }
    }

    private static abstract class EntryFunction
    extends Enum<EntryFunction>
    implements Function<Map.Entry<?, ?>, Object> {
        public static final /* enum */ EntryFunction KEY = new EntryFunction(){

            @Override
            public @Nullable Object apply(Map.Entry<?, ?> entry) {
                return entry.getKey();
            }
        };
        public static final /* enum */ EntryFunction VALUE = new EntryFunction(){

            @Override
            public @Nullable Object apply(Map.Entry<?, ?> entry) {
                return entry.getValue();
            }
        };
        private static final /* synthetic */ EntryFunction[] $VALUES;

        private static /* synthetic */ EntryFunction[] $values() {
            return new EntryFunction[]{KEY, VALUE};
        }

        static {
            $VALUES = EntryFunction.$values();
        }
    }
}

