/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.dom.event.EventType;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.time.Timestamp;

final class ClassPreLoader {
    private static final ImmutableSet<Class<?>> CLASSES = ImmutableSet.of(Timestamp.class, EventType.class, Scheme.class);

    private ClassPreLoader() {
    }

    static void ensureRequiredClassesLoaded() {
        CLASSES.forEach(ClassPreLoader::loadClass);
    }

    private static void loadClass(Class<?> cls) {
        try {
            Class.forName(cls.getName());
        }
        catch (ClassNotFoundException e) {
            Logger.debug("Failed to load the required class: {0}\n{1}", cls.getName(), e);
        }
    }
}

