/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateArrayBufferRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateArrayRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateMapRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateObjectResponse;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateSetRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.PageContextStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.CloseableMap;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.PageContextId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValues;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntries;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class PageContext
extends CloseableImpl {
    private static final CloseableMap<PageContextId, PageContext> pageContexts = CloseableMap.wrap(new ConcurrentHashMap());
    private final PageContextId id;
    private final DomContext domContext;
    private final JsContext jsContext;
    private final ServiceConnection<PageContextStub> rpc;

    public static PageContext of(PageContextId id) {
        return Optional.ofNullable((PageContext)pageContexts.get(id)).orElseThrow(IllegalStateException::new);
    }

    private PageContext(FrameImpl frame, PageContextId pageContextId) {
        this.id = pageContextId;
        this.domContext = DomContext.newInstance(frame, this);
        this.jsContext = JsContext.newInstance(frame, this);
        Connection connection = frame.renderProcess().connection();
        this.rpc = new ServiceConnectionImpl<PageContextStub>(this.id, connection, PageContextStub::new);
        pageContexts.put(this.id, this);
    }

    static PageContext newInstance(FrameImpl frame, PageContextId id) {
        Preconditions.checkNotNull(frame);
        return new PageContext(frame, id);
    }

    private JsValues serializeIterable(Iterable<?> iterable) {
        ByteString.Output stream = ByteString.newOutput();
        try {
            for (Object item : iterable) {
                JsValue.from(this.jsContext, item).impl().writeDelimitedTo(stream);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize the values.", e);
        }
        return JsValues.newBuilder().setSerializedValues(stream.toByteString()).build();
    }

    public JsObjectId createJsArray(List<?> values) {
        CreateObjectResponse response = (CreateObjectResponse)this.rpc.invoke(this.rpc.stub()::createArray, CreateArrayRequest.newBuilder().setPageContextId(this.id).setItems(this.serializeIterable(values)).build());
        return this.jsObjectIdFrom(response);
    }

    public JsObjectId createJsSet(Set<?> values) {
        CreateObjectResponse response = (CreateObjectResponse)this.rpc.invoke(this.rpc.stub()::createSet, CreateSetRequest.newBuilder().setPageContextId(this.id).setItems(this.serializeIterable(values)).build());
        return this.jsObjectIdFrom(response);
    }

    public JsObjectId createJsMap(Map<?, ?> map) {
        ByteString.Output stream = ByteString.newOutput();
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                MapEntry.newBuilder().setKey(JsValue.from(this.jsContext, entry.getKey()).impl()).setValue(JsValue.from(this.jsContext, entry.getValue()).impl()).build().writeDelimitedTo(stream);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize the map values.", e);
        }
        MapEntries entries = MapEntries.newBuilder().setSerializedEntries(stream.toByteString()).build();
        CreateObjectResponse response = (CreateObjectResponse)this.rpc.invoke(this.rpc.stub()::createMap, CreateMapRequest.newBuilder().setPageContextId(this.id).setEntries(entries).build());
        return this.jsObjectIdFrom(response);
    }

    public JsObjectId createJsArrayBuffer(byte[] bytes) {
        CreateObjectResponse response = (CreateObjectResponse)this.rpc.invoke(this.rpc.stub()::createArrayBuffer, CreateArrayBufferRequest.newBuilder().setPageContextId(this.id).setData(ByteString.copyFrom(bytes)).build());
        return this.jsObjectIdFrom(response);
    }

    private JsObjectId jsObjectIdFrom(CreateObjectResponse response) {
        if (response.hasObjectId()) {
            return response.getObjectId();
        }
        if (response.getResultCase() == CreateObjectResponse.ResultCase.PAGE_CONTEXT_NOT_FOUND) {
            throw new IllegalStateException("The page context is already closed.");
        }
        throw new IllegalStateException("The response is empty.");
    }

    @Override
    public void close() {
        super.close();
        this.domContext.close();
        this.jsContext.close();
        pageContexts.remove(this.id);
        this.rpc.close();
    }

    public DomContext domContext() {
        return this.domContext;
    }

    public JsContext jsContext() {
        return this.jsContext;
    }
}

