/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class BooleanValue
extends AbstractValue {
    BooleanValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.BOOL_VALUE);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(Boolean.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: " + type);
        return (T)Boolean.valueOf(this.jsValue().getBoolValue());
    }
}

