/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.CollectionValue;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.js.internal.JsMapImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;
import java.util.Map;

final class MapValue
extends CollectionValue {
    MapValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.MAP_ID);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(Map.class, JsObject.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: " + type);
        JsMapImpl map = this.getOrCreateJsObject(this.jsValue().getMapId(), JsMapImpl.class);
        if (type.equals(Map.class)) {
            return (T)map.toMap();
        }
        return (T)map;
    }
}

