/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class BrowserThread
extends CloseableImpl
implements RpcThread {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final Map<Object, TaskRunner> taskRunners = new ConcurrentHashMap<Object, TaskRunner>();
    private final TaskRunner mainTaskRunner = new TaskRunner();
    private final Thread thread;

    public BrowserThread(String threadName, String threadId) {
        this.thread = new Thread(this.mainTaskRunner::processTasks, String.format("%s: %s", threadName, threadId));
        this.thread.start();
        Logger.debug("RPC thread started: id = {0}", this.thread.getId());
    }

    @Override
    public void close() {
        Logger.debug("Closing RPC thread...");
        this.taskRunners.values().forEach(CloseableImpl::close);
        this.mainTaskRunner.close();
        super.close();
        Logger.debug("Closing RPC thread... [OK]");
    }

    @Override
    public boolean isCurrentlyOn() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void submit(Runnable task) {
        Preconditions.checkState(!this.isClosed());
        Preconditions.checkNotNull(task);
        if (!this.queue.add(task)) {
            Logger.error("Submitting task to RPC thread queue... [FAIL]");
            throw new IllegalStateException("Failed to submit a task to RPC thread queue");
        }
    }

    @Override
    public <T> T execute(Callable<T> task) throws ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(task);
        this.submit(futureTask);
        while (!this.isClosed()) {
            try {
                if (futureTask.isDone()) {
                    return futureTask.get();
                }
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    @Override
    public RpcThread.TaskRunner enterNestedLoop(Object key) {
        Logger.debug("Entering nested loop...");
        Preconditions.checkState(!this.isClosed());
        TaskRunner taskRunner = new TaskRunner();
        this.taskRunners.put(key, taskRunner);
        return taskRunner;
    }

    @Override
    public void exitNestedLoop(Object key) {
        Logger.debug("Exiting nested loop...");
        Preconditions.checkState(!this.isClosed());
        Preconditions.checkState(this.taskRunners.containsKey(key));
        TaskRunner taskRunner = this.taskRunners.remove(key);
        taskRunner.close();
    }

    private final class TaskRunner
    extends CloseableImpl
    implements RpcThread.TaskRunner {
        private TaskRunner() {
        }

        @Override
        public void close() {
            super.close();
            if (BrowserThread.this.queue.isEmpty()) {
                BrowserThread.this.submit(() -> {});
            }
        }

        @Override
        public void processTasks() {
            BrowserThread browserThread = BrowserThread.this;
            Preconditions.checkState(browserThread.isCurrentlyOn(), "The task runner must only be be run on the Browser Thread.");
            while (!this.isClosed()) {
                try {
                    ((Runnable)BrowserThread.this.queue.take()).run();
                }
                catch (InterruptedException e) {
                    Logger.error("The current thread has been interrupted.", e);
                    this.close();
                }
                catch (Throwable e) {
                    Thread currentThread = Thread.currentThread();
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = currentThread.getUncaughtExceptionHandler();
                    uncaughtExceptionHandler.uncaughtException(currentThread, e);
                    Logger.error("Failed to process task.", e);
                }
            }
        }
    }
}

