/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ChromiumFiles {
    private final ImmutableList<ChromiumFile> files;
    private final ChromiumFile executableFile;

    static Optional<ChromiumFiles> listForMac() {
        Optional result = Optional.empty();
        if (Environment.isMac()) {
            result = ListingFile.read(ListingFile.MAC, "Chromium.app/Contents/MacOS/Chromium");
        }
        return result;
    }

    static Optional<ChromiumFiles> listForMacArm() {
        Optional result = Optional.empty();
        if (Environment.isMac()) {
            result = ListingFile.read(ListingFile.MAC_ARM, "Chromium.app/Contents/MacOS/Chromium");
        }
        return result;
    }

    public static Optional<ChromiumFiles> listForLinuxArm() {
        Optional result = Optional.empty();
        if (Environment.isLinux() && Environment.isArm()) {
            result = ListingFile.read(ListingFile.LINUX_ARM, "chromium");
        }
        return result;
    }

    public static Optional<ChromiumFiles> listForLinux64() {
        Optional result = Optional.empty();
        if (Environment.isLinux() && !Environment.isArm()) {
            result = ListingFile.read(ListingFile.LINUX, "chromium");
        }
        return result;
    }

    static Optional<ChromiumFiles> listForWin64() {
        Optional result = Optional.empty();
        if (Environment.isWindows64()) {
            result = ListingFile.read(ListingFile.WIN64, "chromium.exe");
        }
        return result;
    }

    static Optional<ChromiumFiles> listForWin32() {
        Optional result = Optional.empty();
        if (Environment.isWindows()) {
            result = ListingFile.read(ListingFile.WIN32, "chromium.exe");
        }
        return result;
    }

    private ChromiumFiles(List<ChromiumFile> files, ChromiumFile executableFile) {
        this.files = ImmutableList.copyOf(files);
        this.executableFile = executableFile;
    }

    public ImmutableList<ChromiumFile> list() {
        return this.files;
    }

    public ChromiumFile executableFile() {
        return this.executableFile;
    }

    private static enum ListingFile {
        WIN32("chromium-win32.info"),
        WIN64("chromium-win64.info"),
        LINUX("chromium-linux64.info"),
        LINUX_ARM("chromium-linux64-arm.info"),
        MAC("chromium-mac.info"),
        MAC_ARM("chromium-mac-arm.info");

        private final String propertyFileName;

        private ListingFile(String propertyFileName) {
            this.propertyFileName = propertyFileName;
        }

        private static Optional<ChromiumFiles> read(ListingFile directoryListing, String executableName) {
            if (directoryListing.exists()) {
                Properties properties = directoryListing.asProperties();
                List<ChromiumFile> files = ListingFile.getFiles(properties);
                ChromiumFile executableFile = ListingFile.findExecutableOrFail(files, executableName);
                return Optional.of(new ChromiumFiles(files, executableFile));
            }
            return Optional.empty();
        }

        private Properties asProperties() {
            URL resourceUrl = this.resourceUrl();
            Properties properties = new Properties();
            try (InputStream inputStream = resourceUrl.openStream();){
                properties.load(inputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load properties file:" + resourceUrl, e);
            }
            return properties;
        }

        private static List<ChromiumFile> getFiles(Properties properties) {
            return properties.stringPropertyNames().stream().map(fileName -> {
                long fileLength = Long.parseLong(properties.getProperty((String)fileName));
                return new ChromiumFile((String)fileName, fileLength);
            }).collect(Collectors.toList());
        }

        private static ChromiumFile findExecutableOrFail(List<ChromiumFile> files, String executableName) {
            return files.stream().filter(file -> file.relativePath().equals(executableName)).findFirst().orElseThrow(ListingFile.noExecutableFound(executableName));
        }

        private boolean exists() {
            return this.resourceUrl() != null;
        }

        private URL resourceUrl() {
            return ChromiumFiles.class.getResource(this.propertyFileName);
        }

        private static Supplier<IllegalStateException> noExecutableFound(String fileName) {
            return () -> new IllegalStateException(String.format("The file list does not contain the executable file: %s", fileName));
        }
    }
}

