/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.Display;
import javax.annotation.Nullable;

public abstract class DisplayWatcher<T> {
    private final Observer observer;
    private Display display;

    protected DisplayWatcher(@Nullable Observer observer) {
        this.observer = observer;
    }

    public abstract void attach(@Nullable T var1);

    public abstract void detach();

    protected void changeDisplay(Display display) {
        if (this.isDisplayChanged(display)) {
            this.display = display;
            this.notifyDisplayChanged(display);
        }
    }

    private void notifyDisplayChanged(Display display) {
        if (this.observer != null) {
            this.observer.onDisplayChanged(display);
        }
    }

    private boolean isDisplayChanged(Display newDisplay) {
        return this.display == null || !this.display.id().equals(newDisplay.id());
    }

    public static interface Observer {
        public void onDisplayChanged(Display var1);
    }
}

