/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Path;
import java.security.AccessController;

public abstract class JniLibrary {
    private static Path libraryPath;

    public static void path(Path path) {
        Preconditions.checkNotNull(path);
        libraryPath = path;
    }

    protected JniLibrary(JniLibraryName name) {
        Preconditions.checkState(libraryPath != null, "The library path has not been specified");
        AccessController.doPrivileged(() -> {
            Path path = libraryPath.toAbsolutePath().resolve(name.toPlatform());
            return JniLibrary.loadLibrary(path);
        });
    }

    private static Void loadLibrary(Path libraryPath) {
        String fullPath = libraryPath.toFile().getAbsolutePath();
        System.load(fullPath);
        Logger.trace("Loaded library: `{0}`", fullPath);
        return null;
    }
}

