/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.UInt64Value;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.js.JsMap;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsMapRequest;
import com.teamdev.jxbrowser.js.internal.rpc.JsMapSetRequest;
import com.teamdev.jxbrowser.js.internal.rpc.JsMapStub;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntries;
import com.teamdev.jxbrowser.js.internal.rpc.MapEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsMapImpl
extends JsObjectImpl
implements JsMap {
    private final ServiceConnectionImpl<JsMapStub> rpc;

    public JsMapImpl(JsContext jsContext, JsObjectId jsObjectId) {
        super(jsContext, jsObjectId);
        this.rpc = new ServiceConnectionImpl<JsMapStub>(this.objectId(), jsContext.connection(), JsMapStub::new);
    }

    @Override
    public JsMap set(Object key, Object value) {
        this.rpc.invoke(this.rpc.stub()::set, JsMapSetRequest.newBuilder().setObjectId(this.objectId()).setKey(this.toJsValue(key)).setValue(this.toJsValue(value)).build());
        return this;
    }

    @Override
    public <T> T get(Object key) {
        JsValue result = (JsValue)this.rpc.invoke(this.rpc.stub()::get, this.requestFrom(key));
        JavaValue value = JavaValue.from(result);
        return value.toReturnValue();
    }

    @Override
    public boolean has(Object key) {
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::has, this.requestFrom(key))).getValue();
    }

    @Override
    public boolean delete(Object key) {
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::delete, this.requestFrom(key))).getValue();
    }

    @Override
    public long size() {
        return ((UInt64Value)this.rpc.invoke(this.rpc.stub()::size, this.objectId())).getValue();
    }

    @Override
    public void clear() {
        this.rpc.invoke(this.rpc.stub()::clear, this.objectId());
    }

    private JsMapRequest requestFrom(Object key) {
        return JsMapRequest.newBuilder().setObjectId(this.objectId()).setKey(this.toJsValue(key)).build();
    }

    @Override
    public Map<Object, Object> toMap() {
        this.checkNotClosed();
        long size = this.size();
        Preconditions.checkState(size <= Integer.MAX_VALUE, "The size exceeds the maximum size of a map.");
        LinkedHashMap map = new LinkedHashMap((int)size);
        MapEntries entries = (MapEntries)this.rpc.invoke(this.rpc.stub()::getEntries, this.objectId());
        InputStream inputStream = entries.getSerializedEntries().newInput();
        try {
            while (inputStream.available() > 0) {
                MapEntry entry = MapEntry.parseDelimitedFrom(inputStream);
                Object key = JavaValue.from(entry.getKey()).toObject();
                Object value = JavaValue.from(entry.getValue()).toObject();
                map.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert the JS map to Java map.", e);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType);
        Preconditions.checkNotNull(valueType);
        this.checkNotClosed();
        long size = this.size();
        Preconditions.checkState(size <= Integer.MAX_VALUE, "The size exceeds the maximum size of a map.");
        LinkedHashMap map = new LinkedHashMap();
        MapEntries entries = (MapEntries)this.rpc.invoke(this.rpc.stub()::getEntries, this.objectId());
        InputStream inputStream = entries.getSerializedEntries().newInput();
        try {
            while (inputStream.available() > 0) {
                MapEntry entry = MapEntry.parseDelimitedFrom(inputStream);
                Object key = JavaValue.from(entry.getKey()).toObject(keyType);
                Object value = JavaValue.from(entry.getValue()).toObject(valueType);
                map.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert the JS map to Java map.", e);
        }
        return Collections.unmodifiableMap(map);
    }
}

