/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.net.UploadData;
import com.teamdev.jxbrowser.net.internal.UploadDataTypes;
import com.teamdev.jxbrowser.net.internal.rpc.File;
import com.teamdev.jxbrowser.net.internal.rpc.MultipartFormData;
import com.teamdev.jxbrowser.net.internal.rpc.MultipartFormDataPair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface MultipartFormData
extends UploadData {
    public static Builder newBuilder() {
        return new Builder();
    }

    @Immutable
    default public List<Pair> data() {
        return Collections.unmodifiableList(UploadDataTypes.cast(this).getDataList());
    }

    @Override
    default public byte[] bytes() {
        return UploadDataTypes.cast(this).getBytes().getData().toByteArray();
    }

    public static final class Builder {
        private final MultipartFormData.Builder builder = com.teamdev.jxbrowser.net.internal.rpc.MultipartFormData.newBuilder();

        private Builder() {
        }

        public Builder addPair(Pair pair) {
            Preconditions.checkNotNull(pair);
            this.builder.addData((MultipartFormDataPair)pair);
            return this;
        }

        public MultipartFormData build() {
            return this.builder.build();
        }
    }

    public static interface Pair {
        public static Pair of(String key, String value) {
            StringPreconditions.checkNotNullEmptyOrBlank(key);
            Preconditions.checkNotNull(value);
            return MultipartFormDataPair.newBuilder().setKey(key).setStringValue(value).build();
        }

        public static Pair of(String key, com.teamdev.jxbrowser.net.File value) {
            StringPreconditions.checkNotNullEmptyOrBlank(key);
            Preconditions.checkNotNull(value);
            return MultipartFormDataPair.newBuilder().setKey(key).setFileValue((File)value).build();
        }

        default public String key() {
            return ((MultipartFormDataPair)this).getKey();
        }

        default public Optional<String> stringValue() {
            MultipartFormDataPair pair = (MultipartFormDataPair)this;
            if (pair.getValueCase() == MultipartFormDataPair.ValueCase.STRING_VALUE) {
                return Optional.of(pair.getStringValue());
            }
            return Optional.empty();
        }

        default public Optional<com.teamdev.jxbrowser.net.File> fileValue() {
            MultipartFormDataPair pair = (MultipartFormDataPair)this;
            if (pair.getValueCase() == MultipartFormDataPair.ValueCase.FILE_VALUE) {
                return Optional.of(pair.getFileValue());
            }
            return Optional.empty();
        }
    }
}

