/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.password.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.password.PasswordRecord;
import com.teamdev.jxbrowser.password.PasswordStore;
import com.teamdev.jxbrowser.password.internal.rpc.PasswordRecordList;
import com.teamdev.jxbrowser.password.internal.rpc.PasswordStoreStub;
import com.teamdev.jxbrowser.password.internal.rpc.RemoveByUrlRequest;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.List;

public final class PasswordStoreImpl
extends CloseableImpl
implements PasswordStore {
    private final ServiceConnectionImpl<PasswordStoreStub> rpc;
    private final ProfileImpl profile;

    public PasswordStoreImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        Connection connection = profile.engine().connection();
        this.rpc = new ServiceConnectionImpl<PasswordStoreStub>(profile.id(), connection, PasswordStoreStub::new);
    }

    @Override
    public List<PasswordRecord> all() {
        this.checkNotClosed();
        return ((PasswordRecordList)this.rpc.invoke(this.rpc.stub()::getAllPasswords, this.profile.id())).getRecordList().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<PasswordRecord> allSaved() {
        this.checkNotClosed();
        return ((PasswordRecordList)this.rpc.invoke(this.rpc.stub()::getSavedPasswords, this.profile.id())).getRecordList().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<PasswordRecord> allNeverSaved() {
        this.checkNotClosed();
        ImmutableList allSavedUrls = this.allSaved().stream().map(PasswordRecord::url).collect(ImmutableList.toImmutableList());
        return this.all().stream().filter(record -> !allSavedUrls.contains(record.url())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void removeByUrl(String url) {
        StringPreconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        RemoveByUrlRequest request = RemoveByUrlRequest.newBuilder().setProfileId(this.profile.id()).setUrl(url).build();
        this.rpc.invoke(this.rpc.stub()::removeByUrl, request);
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::clear, this.profile.id());
    }

    @Override
    public Profile profile() {
        return this.profile;
    }
}

