/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.internal.rpc.Cursor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;

final class CursorConfiguration {
    private static final String CURSOR_PROPERTIES_WINDOWS = "/com/teamdev/jxbrowser/ui/cursors/win/cursors.properties";
    private static final String CURSOR_PROPERTIES_MAC = "/com/teamdev/jxbrowser/ui/cursors/mac/cursors.properties";
    private static final String DOT_FILE = ".file";
    private static final String DOT_HOTSPOT = ".hotspot";
    private final Properties properties;

    private CursorConfiguration(Properties properties) {
        this.properties = properties;
    }

    private CursorConfiguration(String resourceName) {
        this(CursorConfiguration.loadResource(resourceName));
    }

    static CursorConfiguration newInstance() {
        if (Environment.isMac()) {
            return new CursorConfiguration(CURSOR_PROPERTIES_MAC);
        }
        return new CursorConfiguration(CURSOR_PROPERTIES_WINDOWS);
    }

    Optional<String> cursorFileName(Cursor.Type cursorType) {
        String cursorFileKey = cursorType.name() + DOT_FILE;
        return Optional.ofNullable(this.properties.getProperty(cursorFileKey));
    }

    Optional<String> cursorHotspotData(Cursor.Type cursorType) {
        String cursorHotspotKey = cursorType.name() + DOT_HOTSPOT;
        return Optional.ofNullable(this.properties.getProperty(cursorHotspotKey));
    }

    private static Properties loadResource(String name) {
        Properties properties = new Properties();
        URL propertiesUrl = CursorConfiguration.class.getResource(name);
        if (propertiesUrl != null) {
            try {
                InputStream inputStream = propertiesUrl.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException ignore) {
                Logger.warn(String.format("Unable to load cursor properties from: %s.", propertiesUrl));
            }
        }
        return properties;
    }
}

