/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.deps.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;

final class BrowserWidgetThread {
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Browser Widget Thread").build());
    private final String browserId;

    BrowserWidgetThread(String browserId) {
        StringPreconditions.checkNotNullEmptyOrBlank(browserId);
        this.browserId = browserId;
    }

    <T> Optional<T> execute(Callable<T> task) {
        return (Optional)((CompletableFuture)this.submit(task).handle((BiFunction)new TaskResultHandler())).join();
    }

    void execute(Runnable task) {
        ((CompletableFuture)this.submit(Executors.callable(task)).handle((BiFunction)new TaskResultHandler())).join();
    }

    void submit(Runnable task) {
        this.submit(Executors.callable(task));
    }

    private <T> CompletableFuture<T> submit(Callable<T> task) {
        try {
            CompletableFuture future = new CompletableFuture();
            this.singleThreadExecutor.execute(() -> {
                try {
                    future.complete(task.call());
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }
        catch (RejectedExecutionException e) {
            Logger.debug("Failed to submit a new task. The widget is already closed.");
            return this.canceledFuture();
        }
    }

    private <T> CompletableFuture<T> canceledFuture() {
        CompletableFuture future = new CompletableFuture();
        future.cancel(true);
        return future;
    }

    void shutdownNow() {
        this.singleThreadExecutor.shutdownNow();
    }

    private final class TaskResultHandler<T>
    implements BiFunction<T, Throwable, Optional<T>> {
        private TaskResultHandler() {
        }

        @Override
        public Optional<T> apply(T result, Throwable throwable) {
            if (throwable != null) {
                Logger.debug(String.format("Failed to execute a task. Browser Id: { %s }. ", BrowserWidgetThread.this.browserId), throwable);
            }
            return Optional.ofNullable(result);
        }
    }
}

