/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.callback.DragAndDropCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.DragAndDropStub;
import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import java.util.Optional;

public final class DragAndDrop
extends CloseableImpl
implements Advisable<DragAndDropCallback> {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<DragAndDropStub> rpc;

    DragAndDrop(BrowserImpl browser) {
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<DragAndDropStub>(browser.id(), browser.engine().connection(), DragAndDropStub::new);
    }

    public void enable() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::enable, this.browser.id());
    }

    public void disable() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::disable, this.browser.id());
    }

    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isEnabled, this.browser.id())).getValue();
    }

    @Override
    public <C extends DragAndDropCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((DragAndDropCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends DragAndDropCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends DragAndDropCallback> C remove(Class<C> callbackClass) {
        return (C)((DragAndDropCallback)this.rpc.remove(callbackClass));
    }
}

