/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.xz.ResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

final class JavaResourceExtractor
implements ResourceExtractor {
    JavaResourceExtractor() {
    }

    @Override
    public void extract(String resourceName, Path destFile) throws IOException {
        if (java.nio.file.Files.exists(destFile, new LinkOption[0])) {
            Files.deleteFile(destFile);
        }
        java.nio.file.Files.createFile(destFile, new FileAttribute[0]);
        URL resourceUrl = ResourceLocator.loadResource(resourceName);
        try (InputStream inputStream = resourceUrl.openStream();
             FileChannel output = FileChannel.open(destFile, StandardOpenOption.WRITE);){
            JavaResourceExtractor.transfer(inputStream, output);
        }
    }

    private static void transfer(InputStream source, FileChannel dest) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(source);
        dest.transferFrom(channel, 0L, Integer.MAX_VALUE);
    }
}

