/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.dom.event.internal.EventTargetImpl;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.js.internal.JsAccessibleObject;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public interface JsValue {
    public static JsValue from(JsContext context, @Nullable Object object) {
        JsValue.Builder builder = com.teamdev.jxbrowser.js.internal.rpc.JsValue.newBuilder();
        if (object instanceof EventTargetImpl) {
            EventTargetImpl eventTarget = (EventTargetImpl)object;
            Preconditions.checkArgument(context.equals(eventTarget.jsContext()));
            builder.setNodeInfo(eventTarget.nodeInfo());
        } else if (object instanceof JsObjectImpl) {
            JsObjectImpl jsObject = (JsObjectImpl)object;
            Preconditions.checkArgument(context.equals(jsObject.jsContext()));
            builder.setObjectId(jsObject.objectId());
        } else if (object instanceof Number) {
            builder.setNumberValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            builder.setBoolValue((Boolean)object);
        } else if (object instanceof String) {
            builder.setStringValue((String)object);
        } else if (object == null) {
            builder.setNullOrUndefined(Protobuf.empty());
        } else {
            JsAccessibleObject accessibleObject = new JsAccessibleObject(object);
            if (accessibleObject.isFunction()) {
                JsObjectProxyId proxyId = context.registerFunction(object);
                builder.setFunctionCallbackId(proxyId);
            } else if (accessibleObject.isAccessible()) {
                JsObjectProxyId proxyId = context.registerObject(object);
                builder.setObjectProxyId(proxyId);
            } else if (object instanceof List) {
                builder.setArrayId(context.pageContext().createJsArray((List)object));
            } else if (object instanceof Set) {
                builder.setSetId(context.pageContext().createJsSet((Set)object));
            } else if (object instanceof Map) {
                builder.setMapId(context.pageContext().createJsMap((Map)object));
            } else if (object instanceof byte[]) {
                builder.setArrayBufferId(context.pageContext().createJsArrayBuffer((byte[])object));
            } else {
                Logger.debug("Registering inaccessible object: {0}", object);
                JsObjectProxyId proxyId = context.registerObject(object);
                builder.setObjectProxyId(proxyId);
            }
        }
        return builder.build();
    }

    default public com.teamdev.jxbrowser.js.internal.rpc.JsValue impl() {
        return (com.teamdev.jxbrowser.js.internal.rpc.JsValue)this;
    }
}

