/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print.internal.settings;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ProtocolMessageEnum;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.DirectoryCreationException;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.rpc.PrintJobId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnection;
import com.teamdev.jxbrowser.print.Capabilities;
import com.teamdev.jxbrowser.print.ColorModel;
import com.teamdev.jxbrowser.print.DuplexMode;
import com.teamdev.jxbrowser.print.Orientation;
import com.teamdev.jxbrowser.print.PageMargins;
import com.teamdev.jxbrowser.print.PageRange;
import com.teamdev.jxbrowser.print.PagesPerSheet;
import com.teamdev.jxbrowser.print.PrintSettings;
import com.teamdev.jxbrowser.print.Scaling;
import com.teamdev.jxbrowser.print.internal.PrintTypes;
import com.teamdev.jxbrowser.print.internal.rpc.ApplySettingsRequest;
import com.teamdev.jxbrowser.print.internal.rpc.Collate;
import com.teamdev.jxbrowser.print.internal.rpc.HeaderTemplate;
import com.teamdev.jxbrowser.print.internal.rpc.PdfFilePath;
import com.teamdev.jxbrowser.print.internal.rpc.PrintJobStub;
import com.teamdev.jxbrowser.print.internal.rpc.PrintSettings;
import com.teamdev.jxbrowser.print.internal.rpc.SelectionOnly;
import com.teamdev.jxbrowser.print.internal.settings.PageRanges;
import com.teamdev.jxbrowser.print.internal.settings.PaperSize;
import com.teamdev.jxbrowser.print.settings.Copies;
import com.teamdev.jxbrowser.print.settings.FooterTemplate;
import com.teamdev.jxbrowser.print.settings.PrintBackgrounds;
import com.teamdev.jxbrowser.print.settings.PrintHeaderFooter;
import com.teamdev.jxbrowser.print.settings.PrintSelectionOnly;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractPrintSettings<T extends PrintSettings>
extends CloseableImpl
implements com.teamdev.jxbrowser.print.settings.Collate<T>,
com.teamdev.jxbrowser.print.settings.ColorModel<T>,
Copies<T>,
com.teamdev.jxbrowser.print.settings.DuplexMode<T>,
FooterTemplate<T>,
com.teamdev.jxbrowser.print.settings.HeaderTemplate<T>,
com.teamdev.jxbrowser.print.settings.Orientation<T>,
com.teamdev.jxbrowser.print.settings.PageMargins<T>,
com.teamdev.jxbrowser.print.settings.PageRanges<T>,
com.teamdev.jxbrowser.print.settings.PagesPerSheet<T>,
com.teamdev.jxbrowser.print.settings.PaperSize<T>,
com.teamdev.jxbrowser.print.settings.PdfFilePath<T>,
PrintBackgrounds<T>,
PrintHeaderFooter<T>,
PrintSelectionOnly<T>,
com.teamdev.jxbrowser.print.settings.Scaling<T> {
    private final PrintJobId printJobId;
    private final ServiceConnection<PrintJobStub> rpc;
    private final Capabilities capabilities;
    private final PrintSettings.Builder builder;
    private com.teamdev.jxbrowser.print.internal.rpc.PrintSettings currentSettings;
    private boolean hasPendingSettings;

    protected AbstractPrintSettings(Capabilities capabilities, PrintJobId printJobId, ServiceConnection<PrintJobStub> rpc, com.teamdev.jxbrowser.print.internal.rpc.PrintSettings defaultSettings) {
        this.capabilities = capabilities;
        this.printJobId = printJobId;
        this.rpc = rpc;
        this.currentSettings = defaultSettings;
        this.builder = this.currentSettings.toBuilder();
        this.hasPendingSettings = true;
    }

    @Override
    public T enableCollatePrinting() {
        Preconditions.checkArgument(this.capabilities.canCollate(), "The printer does not support collate printing.");
        this.builder.setCollate(Collate.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disableCollatePrinting() {
        this.builder.setCollate(Collate.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T colorModel(ColorModel colorModel) {
        Preconditions.checkNotNull(colorModel);
        Preconditions.checkArgument(this.capabilities.colorModels().contains(colorModel), String.format("The color model is not supported: %s.", colorModel));
        this.builder.setColorModel(colorModel);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T copies(int copies) {
        Preconditions.checkArgument(copies >= 1, "The number of copies must be >= 1.");
        Preconditions.checkArgument(this.capabilities.maxCopies() >= copies, "The printer does not support this number of copies.");
        this.builder.setCopies(com.teamdev.jxbrowser.print.internal.rpc.Copies.newBuilder().setValue(copies).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T duplexMode(DuplexMode duplexMode) {
        Preconditions.checkNotNull(duplexMode);
        Preconditions.checkArgument(this.capabilities.duplexModes().contains(duplexMode), String.format("The printer does not support the duplex mode: %s.", duplexMode));
        this.builder.setDuplexMode(duplexMode);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageRanges(Set<PageRange> pageRanges) {
        Preconditions.checkNotNull(pageRanges);
        this.builder.setPageRanges(PrintTypes.cast(PageRanges.from(pageRanges)));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageRanges(PageRange ... pageRanges) {
        Preconditions.checkNotNull(pageRanges);
        return this.pageRanges(ImmutableSet.copyOf(pageRanges));
    }

    @Override
    public T pagesPerSheet(PagesPerSheet pagesPerSheet) {
        Preconditions.checkNotNull(pagesPerSheet);
        AbstractPrintSettings.checkNotUnspecifiedOrUnrecognized(pagesPerSheet);
        this.builder.setPagesPerSheet(pagesPerSheet);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T paperSize(com.teamdev.jxbrowser.print.PaperSize paperSize) {
        Preconditions.checkNotNull(paperSize);
        this.builder.setPaperSize(PrintTypes.cast(PaperSize.from(paperSize)));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pageMargins(PageMargins pageMargins) {
        Preconditions.checkNotNull(pageMargins);
        this.builder.setPageMargins(PrintTypes.cast(pageMargins));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingHeaderFooter() {
        this.builder.setPrintHeaderFooter(com.teamdev.jxbrowser.print.internal.rpc.PrintHeaderFooter.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingHeaderFooter() {
        this.builder.setPrintHeaderFooter(com.teamdev.jxbrowser.print.internal.rpc.PrintHeaderFooter.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T orientation(Orientation orientation) {
        Preconditions.checkNotNull(orientation);
        AbstractPrintSettings.checkNotUnspecifiedOrUnrecognized(orientation);
        this.builder.setOrientation(orientation);
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingBackgrounds() {
        this.builder.setPrintBackgrounds(com.teamdev.jxbrowser.print.internal.rpc.PrintBackgrounds.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingBackgrounds() {
        this.builder.setPrintBackgrounds(com.teamdev.jxbrowser.print.internal.rpc.PrintBackgrounds.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T enablePrintingSelectionOnly() {
        this.builder.setSelectionOnly(SelectionOnly.newBuilder().setValue(true).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T disablePrintingSelectionOnly() {
        this.builder.setSelectionOnly(SelectionOnly.getDefaultInstance());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T pdfFilePath(Path pdfFilePath) {
        Preconditions.checkNotNull(pdfFilePath);
        Preconditions.checkArgument(pdfFilePath.isAbsolute());
        try {
            Files.createDirs(pdfFilePath.getParent());
        }
        catch (DirectoryCreationException e) {
            throw new IllegalArgumentException("The parent directory cannot be created.", e);
        }
        this.builder.setPdfFilePath(PdfFilePath.newBuilder().setValue(pdfFilePath.toString()).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T header(String header) {
        Preconditions.checkNotNull(header);
        this.builder.setHeaderTemplate(HeaderTemplate.newBuilder().setValue(header).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T footer(String footer) {
        Preconditions.checkNotNull(footer);
        this.builder.setFooterTemplate(com.teamdev.jxbrowser.print.internal.rpc.FooterTemplate.newBuilder().setValue(footer).build());
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public T scaling(Scaling scaling) {
        Preconditions.checkNotNull(scaling);
        this.builder.setScaling(PrintTypes.cast(scaling));
        return (T)((PrintSettings)((Object)this));
    }

    @Override
    public boolean isCollatePrintingEnabled() {
        return this.currentSettings.getCollate().getValue();
    }

    @Override
    public ColorModel colorModel() {
        return this.currentSettings.getColorModel();
    }

    @Override
    public int copies() {
        return this.currentSettings.getCopies().getValue();
    }

    @Override
    public DuplexMode duplexMode() {
        return this.currentSettings.getDuplexMode();
    }

    @Override
    public Set<PageRange> pageRanges() {
        return this.currentSettings.getPageRanges().toPublic();
    }

    @Override
    public PagesPerSheet pagesPerSheet() {
        return this.currentSettings.getPagesPerSheet();
    }

    @Override
    public com.teamdev.jxbrowser.print.PaperSize paperSize() {
        return this.currentSettings.getPaperSize().toPublic();
    }

    @Override
    public PageMargins pageMargins() {
        return this.currentSettings.getPageMargins();
    }

    @Override
    public boolean isPrintingHeaderFooterEnabled() {
        return this.currentSettings.getPrintHeaderFooter().getValue();
    }

    @Override
    public Orientation orientation() {
        return this.currentSettings.getOrientation();
    }

    @Override
    public boolean isPrintingBackgroundsEnabled() {
        return this.currentSettings.getPrintBackgrounds().getValue();
    }

    @Override
    public boolean isPrintingSelectionOnlyEnabled() {
        return this.currentSettings.getSelectionOnly().getValue();
    }

    @Override
    public Optional<Path> pdfFilePath() {
        if (this.currentSettings.hasPdfFilePath()) {
            return Optional.of(Paths.get(this.currentSettings.getPdfFilePath().getValue(), new String[0]));
        }
        return Optional.empty();
    }

    @Override
    public String header() {
        return this.currentSettings.getHeaderTemplate().getValue();
    }

    @Override
    public String footer() {
        return this.currentSettings.getFooterTemplate().getValue();
    }

    @Override
    public Scaling scaling() {
        return this.currentSettings.getScaling();
    }

    public com.teamdev.jxbrowser.print.internal.rpc.PrintSettings currentSettings() {
        return this.currentSettings;
    }

    protected void buildSettings() {
        this.currentSettings = this.builder.build();
    }

    public void apply() {
        this.checkNotClosed();
        if (!this.hasPendingSettings) {
            return;
        }
        this.buildSettings();
        BoolValue success = (BoolValue)this.rpc.invoke(this.rpc.stub()::applySettings, this.applySettingsRequest());
        if (!success.getValue()) {
            throw new IllegalArgumentException("Failed to apply the configured settings.");
        }
        this.hasPendingSettings = false;
    }

    private ApplySettingsRequest applySettingsRequest() {
        return ApplySettingsRequest.newBuilder().setPrintJobId(this.printJobId).setSettings(this.currentSettings).build();
    }

    private static void checkNotUnspecifiedOrUnrecognized(ProtocolMessageEnum value) {
        Preconditions.checkArgument(value.getNumber() > 0, "Unsupported value: " + value);
    }
}

