/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.internal.mac;

import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.AccessibilityNode;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.view.internal.mac.NsView;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class NsAccessibility {
    private final ToolkitLibrary toolkit;
    private final BrowserWidget browserWidget;
    private final long nsViewId;
    private long parentNsViewId;

    NsAccessibility(BrowserWidget browserWidget, NsView nsView) {
        Preconditions.checkNotNull(browserWidget);
        Preconditions.checkNotNull(nsView);
        this.toolkit = ToolkitLibrary.instance();
        this.browserWidget = browserWidget;
        this.nsViewId = nsView.id();
    }

    void configureRemoteAccessibility(long parentNsViewId) {
        this.parentNsViewId = parentNsViewId;
        this.browserWidget.accessibilityToken().ifPresent(token -> {
            this.toolkit.addAccessibilityNode(parentNsViewId, token.getAccessibilityNode().getDataList(), token.getProcessId());
            AccessibilityNode windowNode = this.accessibilityNode(parentNsViewId);
            AccessibilityNode viewNode = this.accessibilityNode(this.nsViewId);
            this.browserWidget.setParentAccessibilityNodes(windowNode, viewNode);
        });
    }

    void removeRemoteAccessibilityNode() {
        this.toolkit.removeAccessibilityNode(this.parentNsViewId);
    }

    void activateRemoteAccessibilityNode() {
        this.toolkit.activateAccessibilityNode(this.parentNsViewId);
    }

    void deactivateRemoteAccessibilityNode() {
        this.toolkit.deactivateAccessibilityNode(this.parentNsViewId);
    }

    private AccessibilityNode accessibilityNode(long nsViewId) {
        AccessibilityNode.Builder builder = AccessibilityNode.newBuilder();
        int[] token = this.toolkit.getAccessibilityNode(nsViewId);
        if (token != null) {
            builder.addAllData(Arrays.stream(token).boxed().collect(Collectors.toList()));
        }
        return builder.build();
    }
}

