/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.ApproximateBounds;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.HiDpi;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public final class DefaultOpenPopupCallback
implements OpenPopupCallback {
    private static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        Browser browser = params.popupBrowser();
        Rect initialBounds = params.initialBounds();
        Platform.runLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            Stage stage = new Stage();
            stage.sizeToScene();
            StackPane root = new StackPane();
            double scaleFactor = params.scaleFactor();
            Scene scene = DefaultOpenPopupCallback.createScene(root, initialBounds.size(), scaleFactor);
            root.getChildren().add((Object)view);
            stage.setScene(scene);
            DefaultOpenPopupCallback.updateOrigin(stage, initialBounds.origin(), scaleFactor);
            stage.setOnCloseRequest(event -> browser.close());
            browser.on(TitleChanged.class, event -> Platform.runLater(() -> stage.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> Platform.runLater(() -> ((Stage)stage).close()));
            browser.on(UpdateBoundsRequested.class, event -> DefaultOpenPopupCallback.updateBounds(event, stage, view));
            stage.show();
        });
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(UpdateBoundsRequested event, Stage stage, BrowserView view) {
        Platform.runLater(() -> {
            Rect newBounds;
            double eventScaleFactor = event.scaleFactor();
            Rect eventBounds = event.bounds();
            Rect rect = newBounds = DefaultOpenPopupCallback.shouldAdjustScaling(eventScaleFactor) ? Geometry.scaleUp((Rect)eventBounds, (double)eventScaleFactor) : eventBounds;
            if (!ApproximateBounds.fuzzyEqual((Size)DefaultOpenPopupCallback.currentSize(view), (Size)newBounds.size())) {
                DefaultOpenPopupCallback.updateSize(stage, eventBounds.size(), eventScaleFactor);
            }
            if (!ApproximateBounds.fuzzyEqual((Point)DefaultOpenPopupCallback.currentOrigin(view), (Point)newBounds.origin())) {
                DefaultOpenPopupCallback.updateOrigin(stage, eventBounds.origin(), eventScaleFactor);
            }
        });
    }

    private static Point currentOrigin(BrowserView view) {
        Point2D viewLocation = view.localToScreen(0.0, 0.0);
        return Geometry.newPoint((double)viewLocation.getX(), (double)viewLocation.getY());
    }

    private static Size currentSize(BrowserView view) {
        Bounds boundsInLocal = view.getBoundsInLocal();
        return Size.of((int)((int)boundsInLocal.getWidth()), (int)((int)boundsInLocal.getHeight()));
    }

    private static Scene createScene(StackPane root, Size size, double scaleFactor) {
        if (size.isEmpty()) {
            return new Scene((Parent)root, (double)DEFAULT_POPUP_SIZE.width(), (double)DEFAULT_POPUP_SIZE.height());
        }
        if (DefaultOpenPopupCallback.shouldAdjustScaling(scaleFactor)) {
            size = Geometry.scaleUp((Size)size, (double)scaleFactor);
        }
        return new Scene((Parent)root, (double)size.width(), (double)size.height());
    }

    private static void updateOrigin(Stage stage, Point origin, double scaleFactor) {
        if (DefaultOpenPopupCallback.shouldAdjustScaling(scaleFactor)) {
            origin = Geometry.scaleUp((Point)origin, (double)scaleFactor);
        }
        stage.setX((double)origin.x());
        stage.setY((double)origin.y());
    }

    private static void updateSize(Stage stage, Size size, double scaleFactor) {
        if (size.isEmpty()) {
            stage.setWidth((double)DEFAULT_POPUP_SIZE.width());
            stage.setHeight((double)DEFAULT_POPUP_SIZE.height());
            return;
        }
        if (DefaultOpenPopupCallback.shouldAdjustScaling(scaleFactor)) {
            size = Geometry.scaleUp((Size)size, (double)scaleFactor);
        }
        stage.setWidth((double)size.width());
        stage.setHeight((double)size.height());
    }

    private static boolean shouldAdjustScaling(double scaleFactor) {
        return !HiDpi.isPlatformDpiAware(scaleFactor);
    }
}

