/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.javafx.internal.OffScreenRenderWidget;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nullable;

final class OffScreenWindowListeners {
    private final OffScreenRenderWidget widget;
    private final WindowLocationListener locationListener;
    private final WindowIconifiedListener iconifiedListener;
    @Nullable
    private Window observedWindow;

    private OffScreenWindowListeners(OffScreenRenderWidget widget) {
        this.widget = widget;
        this.locationListener = new WindowLocationListener();
        this.iconifiedListener = new WindowIconifiedListener();
    }

    static OffScreenWindowListeners newInstance(OffScreenRenderWidget widget) {
        Preconditions.checkNotNull((Object)widget);
        return new OffScreenWindowListeners(widget);
    }

    void start(Window window) {
        if (this.observedWindow == null) {
            this.addListeners(window);
        }
    }

    void stop() {
        if (this.observedWindow != null) {
            this.removeListeners();
        }
    }

    private void addListeners(Window window) {
        this.observedWindow = window;
        window.xProperty().addListener((ChangeListener)this.locationListener);
        window.yProperty().addListener((ChangeListener)this.locationListener);
        if (window instanceof Stage) {
            ((Stage)window).iconifiedProperty().addListener((ChangeListener)this.iconifiedListener);
        }
    }

    private void removeListeners() {
        Preconditions.checkNotNull((Object)this.observedWindow);
        this.observedWindow.xProperty().removeListener((ChangeListener)this.locationListener);
        this.observedWindow.yProperty().removeListener((ChangeListener)this.locationListener);
        if (this.observedWindow instanceof Stage) {
            ((Stage)this.observedWindow).iconifiedProperty().removeListener((ChangeListener)this.iconifiedListener);
        }
    }

    private class WindowIconifiedListener
    implements ChangeListener<Boolean> {
        private WindowIconifiedListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                OffScreenWindowListeners.this.widget.widget().minimize();
            } else {
                OffScreenWindowListeners.this.widget.widget().restore();
            }
        }
    }

    private class WindowLocationListener
    implements ChangeListener<Number> {
        private WindowLocationListener() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            OffScreenWindowListeners.this.widget.notifyBoundsUpdated();
        }
    }
}

