/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.view.javafx.internal.ClosestParentTab;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tab;

final class ParentTabTracker {
    private final Node widget;
    private final TabSelectionListener tabListener;
    private final Runnable whenSelectedCallback;
    private final Runnable whenDeselectedCallback;
    private Tab watchedTab;

    private ParentTabTracker(Builder builder) {
        this.widget = builder.widget;
        this.tabListener = new TabSelectionListener();
        this.whenSelectedCallback = builder.whenSelectedCallback;
        this.whenDeselectedCallback = builder.whenDeselectedCallback;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    void start() {
        Optional<Tab> tab = ClosestParentTab.ofNode(this.widget);
        tab.ifPresent(this::attachListener);
    }

    void stop() {
        if (this.watchedTab != null) {
            this.detachListener();
        }
    }

    void restart() {
        this.stop();
        this.start();
    }

    private void attachListener(Tab tab) {
        this.watchedTab = tab;
        this.watchedTab.selectedProperty().addListener((ChangeListener)this.tabListener);
    }

    private void detachListener() {
        if (this.watchedTab != null) {
            this.watchedTab.selectedProperty().removeListener((ChangeListener)this.tabListener);
            this.watchedTab = null;
        }
    }

    private final class TabSelectionListener
    implements ChangeListener<Boolean> {
        private TabSelectionListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                ParentTabTracker.this.whenSelectedCallback.run();
            } else {
                ParentTabTracker.this.whenDeselectedCallback.run();
            }
        }
    }

    static class Builder {
        private Node widget;
        private Runnable whenSelectedCallback;
        private Runnable whenDeselectedCallback;

        Builder() {
        }

        Builder forNode(Node node) {
            this.widget = node;
            return this;
        }

        Builder whenTabSelected(Runnable whenSelected) {
            this.whenSelectedCallback = whenSelected;
            return this;
        }

        Builder whenTabDeselected(Runnable whenDeselected) {
            this.whenDeselectedCallback = whenDeselected;
            return this;
        }

        ParentTabTracker build() {
            Preconditions.checkNotNull((Object)this.widget);
            Preconditions.checkNotNull((Object)this.whenSelectedCallback);
            Preconditions.checkNotNull((Object)this.whenDeselectedCallback);
            return new ParentTabTracker(this);
        }
    }
}

