/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MoveMouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.PressMouse;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.scene.Node;

abstract class ContextMenu {
    private final ShowContextMenuCallback.Params params;
    private final ShowContextMenuCallback.Action callback;
    private final BrowserView parent;
    private final BrowserImpl browser;
    private final RenderingMode renderingMode;
    private final javafx.scene.control.ContextMenu contextMenu;

    ContextMenu(BrowserView parent, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        this.parent = parent;
        this.browser = (BrowserImpl)parent.getBrowser();
        this.renderingMode = this.browser.engine().options().renderingMode();
        this.params = params;
        this.callback = callback;
        this.contextMenu = new javafx.scene.control.ContextMenu();
    }

    final ShowContextMenuCallback.Params params() {
        return this.params;
    }

    final ShowContextMenuCallback.Action callback() {
        return this.callback;
    }

    protected abstract void initialize(javafx.scene.control.ContextMenu var1);

    public final void show() {
        this.contextMenu.setOnHidden(event -> {
            if (this.isHardwareAccelerated()) {
                this.unregisterMouseCallbackInterceptors();
            } else {
                this.parent.setMouseTransparent(false);
            }
            if (!this.callback.isClosed()) {
                this.callback.close();
            }
        });
        this.initialize(this.contextMenu);
        if (this.isHardwareAccelerated()) {
            this.registerMouseCallbackInterceptors();
        } else {
            this.parent.setMouseTransparent(true);
        }
        Point location = this.params.location();
        Point2D screenLocation = this.parent.localToScreen(location.x(), location.y());
        Platform.runLater(() -> this.contextMenu.show((Node)this.parent, screenLocation.getX(), screenLocation.getY()));
    }

    private void registerMouseCallbackInterceptors() {
        this.browser.setCallbackInterceptor(MoveMouseWheel.Request.class, scrollParams -> {
            this.hide(this.contextMenu);
            return Interceptor.Action.PROCEED;
        });
        this.browser.setCallbackInterceptor(PressMouse.Request.class, pressParams -> {
            this.hide(this.contextMenu);
            return Interceptor.Action.PROCEED;
        });
    }

    private void unregisterMouseCallbackInterceptors() {
        this.browser.setCallbackInterceptor(MoveMouseWheel.Request.class, params -> Interceptor.Action.PROCEED);
        this.browser.setCallbackInterceptor(PressMouse.Request.class, params -> Interceptor.Action.PROCEED);
    }

    private void hide(javafx.scene.control.ContextMenu contextMenu) {
        Platform.runLater(() -> {
            if (contextMenu.isShowing()) {
                contextMenu.hide();
            }
        });
    }

    private boolean isHardwareAccelerated() {
        return this.renderingMode == RenderingMode.HARDWARE_ACCELERATED;
    }
}

