/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.callback.internal.PrintCallbackResponses;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.print.PdfPrinter;
import com.teamdev.jxbrowser.print.Printer;
import com.teamdev.jxbrowser.print.Printers;
import com.teamdev.jxbrowser.print.SystemPrinter;
import com.teamdev.jxbrowser.print.internal.PrintTypes;
import com.teamdev.jxbrowser.print.internal.PrinterImpl;
import com.teamdev.jxbrowser.print.internal.PrintersImpl;
import com.teamdev.jxbrowser.print.internal.rpc.PrintHtml;
import java.util.function.Consumer;

public interface PrintHtmlCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<PrintHtml.Response> {
        public Action(Consumer<PrintHtml.Response> consumer) {
            super(consumer);
        }

        public void proceed(Printer<?> printer) {
            Preconditions.checkNotNull(printer);
            PrinterImpl printerImpl = (PrinterImpl)printer;
            printerImpl.applySettings();
            this.send(PrintCallbackResponses.printHtmlResponse(printerImpl.printer()));
        }

        public void cancel() {
            this.send(PrintCallbackResponses.cancelHtmlPrintingResponse());
        }
    }

    public static interface Params {
        default public Printers<PdfPrinter.HtmlSettings, SystemPrinter.HtmlSettings> printers() {
            return PrintersImpl.from(PrintTypes.cast(this));
        }
    }
}

