/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.callback.internal;

import com.teamdev.jxbrowser.callback.Advisable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.TypeInspector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class DefaultCallbacks<C extends Callback> {
    private final Advisable<C> advisable;
    private final Map<Class<? extends C>, C> callbacks;
    private final Map<Class<? extends C>, C> registered;

    public static <C extends Callback> Builder<C> of(Advisable<C> advisable) {
        return new Builder(advisable);
    }

    private DefaultCallbacks(Builder<C> builder) {
        this.advisable = ((Builder)builder).advisable;
        this.callbacks = Collections.unmodifiableMap(((Builder)builder).callbacks);
        this.registered = new HashMap<Class<? extends C>, C>();
    }

    public synchronized void register() {
        this.callbacks.forEach((cls, callback) -> {
            if (this.advisable.get(cls).isPresent()) {
                return;
            }
            this.set((Class)cls, (C)callback);
            this.registered.put((Class<C>)cls, (C)callback);
        });
    }

    public synchronized void unregister() {
        this.registered.forEach((cls, callback) -> {
            Optional existing = this.advisable.get(cls);
            if (existing.isPresent() && ((Callback)existing.get()).equals(callback)) {
                this.advisable.remove(cls);
            }
        });
        this.registered.clear();
    }

    private <T extends C> void set(Class<T> callbackClass, C callback) {
        this.advisable.set(callbackClass, callback);
    }

    public static class Builder<C extends Callback> {
        private final Advisable<C> advisable;
        private final Map<Class<? extends C>, C> callbacks;

        private Builder(Advisable<C> advisable) {
            this.advisable = advisable;
            this.callbacks = new HashMap<Class<? extends C>, C>();
        }

        public <T extends C> Builder<C> add(T callback) {
            TypeInspector typeInspector = new TypeInspector((Callback)callback);
            Class<? extends Callback> iface = typeInspector.closestCallbackInterface();
            this.callbacks.put(iface, callback);
            return this;
        }

        public DefaultCallbacks<C> build() {
            return new DefaultCallbacks(this);
        }
    }
}

