/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.event.Event;
import com.teamdev.jxbrowser.dom.event.EventParams;
import com.teamdev.jxbrowser.dom.event.EventType;
import com.teamdev.jxbrowser.dom.event.KeyEvent;
import com.teamdev.jxbrowser.dom.event.KeyEventParams;
import com.teamdev.jxbrowser.dom.event.MouseEvent;
import com.teamdev.jxbrowser.dom.event.MouseEventParams;
import com.teamdev.jxbrowser.dom.event.WheelEvent;
import com.teamdev.jxbrowser.dom.event.WheelEventParams;
import com.teamdev.jxbrowser.dom.event.internal.EventImpl;
import com.teamdev.jxbrowser.dom.event.internal.KeyEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.MouseEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.WheelEventImpl;
import com.teamdev.jxbrowser.dom.event.internal.rpc.KeyEventType;
import com.teamdev.jxbrowser.dom.internal.DomTypes;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.NodeImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateElementRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateEventRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateKeyEventRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateMouseEventRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateTextNodeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.CreateWheelEventRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.DocumentStub;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.EventId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.Optional;

public final class DocumentImpl
extends NodeImpl
implements Document {
    private final ServiceConnectionImpl<DocumentStub> rpc;

    public static DocumentImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new DocumentImpl(connection, domContext, nodeInfo);
    }

    private DocumentImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<DocumentStub>(nodeInfo, connection, DocumentStub::new);
    }

    @Override
    public Optional<Element> documentElement() {
        this.checkNotClosed();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getDocumentElement, this.frameId());
        return this.domContext().toOptionalNode(response, Element.class);
    }

    @Override
    public Element createElement(String tagName) {
        StringPreconditions.checkNotNullEmptyOrBlank(tagName);
        this.checkNotClosed();
        CreateElementRequest request = CreateElementRequest.newBuilder().setFrameId(this.frameId()).setTagName(tagName).build();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::createElement, request);
        return this.domContext().toNode(response, ElementImpl.class);
    }

    @Override
    public Node createTextNode() {
        return this.createTextNode("");
    }

    @Override
    public Node createTextNode(String text) {
        Preconditions.checkNotNull(text);
        this.checkNotClosed();
        CreateTextNodeRequest request = CreateTextNodeRequest.newBuilder().setFrameId(this.frameId()).setText(text).build();
        return this.domContext().toNode((NodeInfo)this.rpc.invoke(this.rpc.stub()::createTextNode, request));
    }

    @Override
    public Event createEvent(EventType eventType, EventParams params) {
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        CreateEventRequest request = CreateEventRequest.newBuilder().setFrameId(this.frameId()).setEventType(DomTypes.unwrap(eventType)).setEventParams(DomTypes.unwrap(params)).build();
        EventId response = Wrappers.unwrap((EventId)this.rpc.invoke(this.rpc.stub()::createDomEvent, request), EventId.class);
        return new EventImpl<EventParams>(this.domContext(), response, eventType, params);
    }

    @Override
    public MouseEvent createMouseEvent(EventType eventType, MouseEventParams params) {
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        CreateMouseEventRequest request = CreateMouseEventRequest.newBuilder().setFrameId(this.frameId()).setEventType(DomTypes.unwrap(eventType)).setMouseEventParams(DomTypes.unwrap(params)).build();
        EventId response = (EventId)this.rpc.invoke(this.rpc.stub()::createDomMouseEvent, request);
        if (response.getValue() == 0) {
            throw new IllegalArgumentException(String.format("Failed to create a %s mouse event", eventType.value()));
        }
        return new MouseEventImpl<MouseEventParams>(this.domContext(), response, eventType, params);
    }

    @Override
    public WheelEvent createWheelEvent(EventType eventType, WheelEventParams params) {
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        CreateWheelEventRequest request = CreateWheelEventRequest.newBuilder().setFrameId(this.frameId()).setEventType(DomTypes.unwrap(eventType)).setWheelEventParams(DomTypes.unwrap(params)).build();
        EventId response = (EventId)this.rpc.invoke(this.rpc.stub()::createDomWheelEvent, request);
        if (response.getValue() == 0) {
            throw new IllegalArgumentException(String.format("Failed to create a %s wheel event", eventType.value()));
        }
        return new WheelEventImpl(this.domContext(), response, eventType, params);
    }

    @Override
    public KeyEvent createKeyUpEvent(KeyEventParams params) {
        return this.createKeyEvent(KeyEventType.KEY_UP, params);
    }

    @Override
    public KeyEvent createKeyDownEvent(KeyEventParams params) {
        return this.createKeyEvent(KeyEventType.KEY_DOWN, params);
    }

    @Override
    public KeyEvent createKeyPressEvent(KeyEventParams params) {
        return this.createKeyEvent(KeyEventType.KEY_PRESS, params);
    }

    private KeyEvent createKeyEvent(KeyEventType keyEventType, KeyEventParams params) {
        EventType eventType;
        Preconditions.checkNotNull(keyEventType);
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        CreateKeyEventRequest request = CreateKeyEventRequest.newBuilder().setFrameId(this.frameId()).setKeyEventType(keyEventType).setKeyEventParams(DomTypes.unwrap(params)).build();
        EventId response = (EventId)this.rpc.invoke(this.rpc.stub()::createDomKeyEvent, request);
        if (response.getValue() == 0) {
            throw new IllegalArgumentException(String.format("Failed to create a %s key event", keyEventType));
        }
        if (keyEventType == KeyEventType.KEY_DOWN) {
            eventType = EventType.KEY_DOWN;
        } else if (keyEventType == KeyEventType.KEY_UP) {
            eventType = EventType.KEY_UP;
        } else if (keyEventType == KeyEventType.KEY_PRESS) {
            eventType = EventType.KEY_PRESS;
        } else {
            throw new IllegalArgumentException("Unsupported event type: " + keyEventType);
        }
        return new KeyEventImpl(this.domContext(), response, eventType, params);
    }

    @Override
    public String baseUri() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getBaseUri, this.frameId())).getValue();
    }

    @Override
    public Optional<Element> focusedElement() {
        this.checkNotClosed();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getFocusedElement, this.frameId());
        return this.domContext().toOptionalNode(response, Element.class);
    }
}

