/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Attribute;
import com.teamdev.jxbrowser.dom.Element;
import com.teamdev.jxbrowser.dom.internal.NodeImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.BlurRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.FocusRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributeNodesRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributesRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetAttributesResponse;
import com.teamdev.jxbrowser.dom.internal.rpc.GetBoundingClientRectRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetInnerHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetInnerTextRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.GetOuterHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.HasAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfoList;
import com.teamdev.jxbrowser.dom.internal.rpc.RemoveAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.ScrollIntoViewRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetAttributeRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetInnerHtmlRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetInnerTextRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetOuterHtmlRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.ui.Rect;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ElementImpl
extends NodeImpl
implements Element {
    private final ServiceConnectionImpl<ElementStub> rpc;

    public static ElementImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new ElementImpl(connection, domContext, nodeInfo);
    }

    ElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<ElementStub>(nodeInfo.getNodeId(), connection, ElementStub::new);
    }

    @Override
    public final String attributeValue(String name) {
        StringPreconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        GetAttributeRequest request = GetAttributeRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAttributeName(name).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getAttribute, request)).getValue();
    }

    @Override
    public final void putAttribute(String attrName, String attrValue) {
        StringPreconditions.checkNotNullEmptyOrBlank(attrName);
        Preconditions.checkNotNull(attrValue);
        this.checkNotClosed();
        SetAttributeRequest request = SetAttributeRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAttributeName(attrName).setAttributeValue(attrValue).build();
        this.rpc.invoke(this.rpc.stub()::setAttribute, request);
    }

    @Override
    public final void removeAttribute(String attrName) {
        StringPreconditions.checkNotNullEmptyOrBlank(attrName);
        this.checkNotClosed();
        RemoveAttributeRequest request = RemoveAttributeRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAttributeName(attrName).build();
        this.rpc.invoke(this.rpc.stub()::removeAttribute, request);
    }

    @Override
    public final boolean hasAttribute(String attrName) {
        StringPreconditions.checkNotNullEmptyOrBlank(attrName);
        this.checkNotClosed();
        HasAttributeRequest request = HasAttributeRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAttributeName(attrName).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasAttribute, request)).getValue();
    }

    @Override
    public final Map<String, String> attributes() {
        this.checkNotClosed();
        GetAttributesRequest request = GetAttributesRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ImmutableMap.copyOf(((GetAttributesResponse)this.rpc.invoke(this.rpc.stub()::getAttributes, request)).getAttributesMap());
    }

    @Override
    public final List<Attribute> attributeNodes() {
        this.checkNotClosed();
        GetAttributeNodesRequest request = GetAttributeNodesRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getAttributeNodes, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), Attribute.class));
    }

    @Override
    public final String innerHtml() {
        this.checkNotClosed();
        GetInnerHtmlRequest request = GetInnerHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getInnerHtml, request)).getValue();
    }

    @Override
    public final boolean innerHtml(String html) {
        Preconditions.checkNotNull(html);
        this.checkNotClosed();
        SetInnerHtmlRequest request = SetInnerHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setInnerHtml(html).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setInnerHtml, request)).getValue();
    }

    @Override
    public final String outerHtml() {
        this.checkNotClosed();
        GetOuterHtmlRequest request = GetOuterHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getOuterHtml, request)).getValue();
    }

    @Override
    public final boolean outerHtml(String html) {
        Preconditions.checkNotNull(html);
        this.checkNotClosed();
        SetOuterHtmlRequest request = SetOuterHtmlRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setOuterHtml(html).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setOuterHtml, request)).getValue();
    }

    @Override
    public final String innerText() {
        this.checkNotClosed();
        GetInnerTextRequest request = GetInnerTextRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getInnerText, request)).getValue();
    }

    @Override
    public final boolean innerText(String innerText) {
        Preconditions.checkNotNull(innerText);
        this.checkNotClosed();
        SetInnerTextRequest request = SetInnerTextRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setInnerText(innerText).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setInnerText, request)).getValue();
    }

    @Override
    public final Rect boundingClientRect() {
        this.checkNotClosed();
        GetBoundingClientRectRequest request = GetBoundingClientRectRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return (Rect)this.rpc.invoke(this.rpc.stub()::getBoundingClientRect, request);
    }

    @Override
    public final void focus() {
        this.checkNotClosed();
        FocusRequest request = FocusRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::focus, request);
    }

    @Override
    public final void blur() {
        this.checkNotClosed();
        BlurRequest request = BlurRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        this.rpc.invoke(this.rpc.stub()::blur, request);
    }

    @Override
    public void scrollIntoView(Element.AlignTo alignTo) {
        Preconditions.checkNotNull(alignTo);
        this.checkNotClosed();
        ScrollIntoViewRequest request = ScrollIntoViewRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setAlignToTop(alignTo.equals((Object)Element.AlignTo.TOP)).build();
        this.rpc.invoke(this.rpc.stub()::scrollIntoView, request);
    }
}

