/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.download.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.DownloadTarget;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.download.internal.DownloadImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.DownloadId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DownloadsImpl
extends CloseableImpl
implements Downloads {
    private final ProfileImpl profile;
    private final List<DownloadImpl> downloads;

    public DownloadsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.downloads = new CopyOnWriteArrayList<DownloadImpl>();
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public void close() {
        this.downloads.forEach(DownloadImpl::close);
        super.close();
    }

    public void register(DownloadId id, DownloadTarget target) {
        Connection connection = this.profile.engine().connection();
        DownloadImpl download = new DownloadImpl(this.profile, connection, id, target);
        this.downloads.add(download);
    }

    @Override
    public List<Download> list() {
        return Collections.unmodifiableList(this.downloads);
    }
}

