/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.reflect.PrimitiveToWrapper;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.js.internal.JsArrayBufferImpl;
import com.teamdev.jxbrowser.js.internal.JsArrayImpl;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsFunctionImpl;
import com.teamdev.jxbrowser.js.internal.JsMapImpl;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.JsPromiseImpl;
import com.teamdev.jxbrowser.js.internal.JsSetImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;
import java.util.Map;

abstract class AbstractValue
implements JavaValue {
    private static final Map<Class<? extends JsObjectImpl>, JsObjectConstructor> constructors;
    private final JsValue jsValue;

    AbstractValue(JsValue jsValue) {
        this.jsValue = jsValue;
    }

    <T extends JsObjectImpl> T getOrCreateJsObject(JsObjectId objectId, Class<T> type) {
        JsContext context = JsContext.of(objectId.getPageContextId());
        return (T)context.findJsObject(objectId, type).orElseGet(() -> {
            Preconditions.checkState(constructors.containsKey(type), "The type is not supported: " + type);
            JsObjectImpl object = constructors.get(type).newInstance(context, objectId);
            context.registerJsObject(object);
            return object;
        });
    }

    JsValue jsValue() {
        return this.jsValue;
    }

    abstract List<Class<?>> destinationTypes();

    @Override
    public <T> T toObject() {
        return this.toObject(this.destinationTypes().get(0));
    }

    @Override
    public boolean isConvertibleTo(Class<?> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            type = new PrimitiveToWrapper().apply(type);
        }
        for (Class<?> destinationType : this.destinationTypes()) {
            if (!type.isAssignableFrom(destinationType)) continue;
            return true;
        }
        return false;
    }

    static {
        ImmutableMap.Builder<Class<JsObjectImpl>, JsObjectConstructor> builder = ImmutableMap.builder();
        builder.put(JsObjectImpl.class, JsObjectImpl::new).put(JsArrayBufferImpl.class, JsArrayBufferImpl::new).put(JsArrayImpl.class, JsArrayImpl::new).put(JsFunctionImpl.class, JsFunctionImpl::new).put(JsMapImpl.class, JsMapImpl::new).put(JsPromiseImpl.class, JsPromiseImpl::new).put(JsSetImpl.class, JsSetImpl::new);
        constructors = builder.build();
    }

    @FunctionalInterface
    static interface JsObjectConstructor {
        public JsObjectImpl newInstance(JsContext var1, JsObjectId var2);
    }
}

