/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.engine.ChromiumBinariesExtractionException;
import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.internal.xz.XzExtractor;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ChromiumExtractor {
    public static void extract(Path chromiumDir) {
        Logger.debug("Finding Chromium binaries in JARs...");
        List<ChromiumArchiveName> archiveNames = ChromiumArchiveName.list();
        for (ChromiumArchiveName archiveName : archiveNames) {
            Logger.debug("Finding {0}...", new Object[]{archiveName});
            Optional<URL> resourceUrl = ResourceLocator.findResource(archiveName.value());
            if (!resourceUrl.isPresent()) {
                Logger.debug("Finding {0}... [FAIL]", new Object[]{archiveName});
                continue;
            }
            AccessController.doPrivileged(() -> {
                Logger.debug("Extracting archive...");
                long time = System.currentTimeMillis();
                XzExtractor.extract(chromiumDir, archiveName);
                long extractionTime = System.currentTimeMillis() - time;
                Logger.debug("Extracting archive... [OK] {0}ms", extractionTime);
                return null;
            });
            return;
        }
        FileNotFoundException cause = new FileNotFoundException(archiveNames.stream().map(ChromiumArchiveName::value).collect(Collectors.joining(", ")));
        throw new ChromiumBinariesExtractionException("Failed to extract Chromium binaries into " + chromiumDir.toAbsolutePath(), cause);
    }

    private ChromiumExtractor() {
    }
}

