/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class ChromiumVerifier {
    private final boolean hasArchive;
    private final ChromiumFiles chromiumFiles;

    protected ChromiumVerifier(ChromiumFiles files, ChromiumArchiveName archiveName) {
        this.chromiumFiles = files;
        this.hasArchive = ResourceLocator.findResource(archiveName.value()).isPresent();
    }

    public final boolean verify(Path chromiumDir) {
        Logger.debug("Using {0} verifier...", this.getClass().getSimpleName());
        for (ChromiumFile chromiumFile : this.chromiumFiles.list()) {
            Path file = chromiumFile.absolutePath(chromiumDir);
            Logger.debug("Verifying {0}...", file);
            if (!Files.exists(file, new LinkOption[0])) {
                Logger.debug("Verifying {0}... [FAIL] File does not exist", file);
                return false;
            }
            if (chromiumFile.length() != file.toFile().length()) {
                Logger.debug("Verifying {0}... [FAIL] File length mismatch", file);
                return false;
            }
            Logger.debug("Verifying {0}... [OK]", file);
        }
        return true;
    }

    public final ChromiumFiles files() {
        return this.chromiumFiles;
    }

    final boolean hasArchive() {
        return this.hasArchive;
    }
}

