/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.reflect;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.Classes;
import com.teamdev.jxbrowser.internal.reflect.ReflectionException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public final class Fields {
    public static Field declaredField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static Field declaredField(String className, String name) {
        return Fields.declaredField(Classes.forName(className), name);
    }

    public static Set<Field> findDeclaredFields(Class<?> cls, Predicate<Field> predicate) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)Arrays.stream(cls.getDeclaredFields()).filter(predicate).collect(ImmutableSet.toImmutableSet()));
        if (cls.getSuperclass() != null) {
            builder.addAll(Fields.findDeclaredFields(cls.getSuperclass(), predicate));
        }
        return builder.build();
    }

    public static Optional<Field> findField(Class<?> cls, String name) {
        return Fields.findDeclaredFields(cls, field -> field.getName().equals(name)).stream().findFirst();
    }

    public static <T> T value(Object instance, Field field) {
        Preconditions.checkNotNull(instance);
        Preconditions.checkNotNull(field);
        try {
            AccessibleObjects.makeAccessible(field);
            Object result = field.get(instance);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static long longValue(Object instance, Field field) {
        Preconditions.checkNotNull(instance);
        Preconditions.checkNotNull(field);
        try {
            AccessibleObjects.makeAccessible(field);
            return field.getLong(instance);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static void setInaccessible(Field field, Object instance, Object value) {
        Preconditions.checkNotNull(field);
        Preconditions.checkNotNull(instance);
        try {
            AccessibleObjects.makeAccessible(field);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    private Fields() {
    }
}

